/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class CopyAction
extends TreeViewerAction {
    private static final String NAME = "Copy";
    private static final String DESCRIPTION = "Copy the selected elements.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData) {
            TreeImageDisplay parentDisplay = selectedDisplay.getParentDisplay();
            if (parentDisplay == null) {
                this.setEnabled(false);
            } else {
                Object parent = parentDisplay.getUserObject();
                if (parent instanceof ProjectData) {
                    this.setEnabled(this.model.isObjectWritable(ho));
                } else {
                    this.setEnabled(false);
                }
            }
        } else if (ho instanceof CategoryData) {
            TreeImageDisplay parentDisplay = selectedDisplay.getParentDisplay();
            if (parentDisplay == null) {
                this.setEnabled(false);
            } else if (parentDisplay.getUserObject() instanceof CategoryGroupData) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof ImageData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else {
            this.setEnabled(false);
        }
    }

    public CopyAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.COPY));
    }

    public void actionPerformed(ActionEvent e) {
        CopyCmd cmd = new CopyCmd(this.model);
        cmd.execute();
    }
}

