/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.DatasetData;

public class ClassifyChildrenAction
extends TreeViewerAction {
    private static final String NAME = "Categorise Images";
    private static final String DESCRIPTION = "Categorise the images contained in the selected folder.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            if (browser.getSelectedDisplays().length > 1) {
                this.setEnabled(false);
                return;
            }
            Object ho = selectedDisplay.getUserObject();
            this.setEnabled(ho instanceof DatasetData || ho instanceof CategoryData);
            return;
        }
        this.setEnabled(false);
    }

    public ClassifyChildrenAction(TreeViewer model) {
        super(model);
        IconManager im = IconManager.getInstance();
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", im.getIcon(IconManager.CLASSIFY));
    }

    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            this.model.classifyChildren(node);
        }
    }
}

