/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ClassifyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class ClassifyAction
extends TreeViewerAction {
    public static final int CLASSIFY = 0;
    public static final int DECLASSIFY = 1;
    private static final String NAME_CLASSIFY = "Categorise";
    private static final String DESCRIPTION_CLASSIFY = "Categorise the selected image.";
    private static final String NAME_DECLASSIFY = "Decategorise";
    private static final String DESCRIPTION_DECLASSIFY = "Decategorise the selected image.";
    private final int index;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (!(selectedDisplay.getUserObject() instanceof ImageData)) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            int n = browser.getSelectedDisplays().length;
            if (n > 1) {
                this.setEnabled(this.index != 1);
            } else {
                this.setEnabled(true);
            }
        }
    }

    public ClassifyAction(TreeViewer model, int index) {
        super(model);
        IconManager im = IconManager.getInstance();
        String d = "";
        Icon icon = null;
        switch (index) {
            case 0: {
                this.name = NAME_CLASSIFY;
                d = DESCRIPTION_CLASSIFY;
                icon = im.getIcon(IconManager.CLASSIFY);
                this.index = index;
                break;
            }
            case 1: {
                this.name = NAME_DECLASSIFY;
                d = DESCRIPTION_DECLASSIFY;
                icon = im.getIcon(IconManager.DECLASSIFY);
                this.index = index;
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        this.putValue("Name", this.name);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(d));
        this.putValue("SmallIcon", icon);
    }

    public void actionPerformed(ActionEvent e) {
        ClassifyCmd cmd = new ClassifyCmd(this.model, this.index);
        cmd.execute();
    }
}

