/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class ClassifierAction
extends TreeViewerAction
implements MouseListener {
    private static final String DESCRIPTION = "Categorise or Decategorise the selected images.\n Press (Shift) to keep the menu on screen when making selection.";
    private Point point;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selectedDisplay.getUserObject() instanceof ImageData);
    }

    public ClassifierAction(TreeViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.CLASSIFIER));
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(1, (Component)source, this.point);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

