/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.DatasetData;

public class AnnotateChildrenAction
extends TreeViewerAction {
    private static final String NAME = "Annotate Images";
    private static final String DESCRIPTION = "Annotate the images contained in the selected folder.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            if (browser.getSelectedDisplays().length > 1) {
                this.setEnabled(false);
                return;
            }
            Object ho = selectedDisplay.getUserObject();
            this.setEnabled(ho instanceof DatasetData || ho instanceof CategoryData);
            return;
        }
        this.setEnabled(false);
    }

    public AnnotateChildrenAction(TreeViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.ANNOTATION));
    }

    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            this.model.annotateChildren(node);
        }
    }
}

