/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PropertiesCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;

public class AnnotateAction
extends TreeViewerAction {
    private static final String NAME = "Annotate";
    private static final String DESCRIPTION_IMAGE = "Annotate the image.";
    private static final String DESCRIPTION_DATASET = "Annotate the dataset.";
    private static final String DESCRIPTION = "Annotate the dataset.";

    private void setValuesFor(Object ho) {
        if (ho instanceof ImageData) {
            this.setEnabled(true);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
            this.description = DESCRIPTION_IMAGE;
        } else if (ho instanceof DatasetData) {
            this.setEnabled(true);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText("Annotate the dataset."));
            this.description = "Annotate the dataset.";
        } else {
            this.setEnabled(false);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText("Annotate the dataset."));
            this.description = "Annotate the dataset.";
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.setEnabled(false);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText("Annotate the dataset."));
            this.description = "Annotate the dataset.";
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null && browser.getSelectedDisplays().length > 1) {
            this.setValuesFor(selectedDisplay.getUserObject());
            return;
        }
        this.setValuesFor(selectedDisplay.getUserObject());
    }

    public AnnotateAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText("Annotate the dataset."));
        this.description = "Annotate the dataset.";
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.ANNOTATION));
    }

    public void actionPerformed(ActionEvent e) {
        TreeImageDisplay[] nodes;
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null && (nodes = browser.getSelectedDisplays()).length > 1) {
            this.model.annotate(nodes);
            return;
        }
        PropertiesCmd cmd = new PropertiesCmd(this.model);
        cmd.execute();
    }
}

