/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ClassifyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ProjectData;

public class AddAction
extends TreeViewerAction {
    private static final String NAME = "...";
    private static final String NAME_DATASET = "Add existing Dataset...";
    private static final String NAME_CATEGORY = "Add existing Category...";
    private static final String NAME_IMAGE = "Add existing Image...";
    private static final String DESCRIPTION = "Add existing elements to the selected container.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.putValue("Name", NAME);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
            this.putValue("Name", NAME);
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.putValue("Name", NAME_DATASET);
        } else if (ho instanceof CategoryGroupData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.putValue("Name", NAME_CATEGORY);
        } else if (ho instanceof CategoryData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.putValue("Name", NAME_IMAGE);
        } else if (ho instanceof DatasetData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.putValue("Name", NAME_IMAGE);
        } else {
            this.setEnabled(false);
            this.putValue("Name", NAME);
        }
        this.name = (String)this.getValue("Name");
    }

    public AddAction(TreeViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.name = (String)this.getValue("Name");
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.ADD_EXISTING));
    }

    public void actionPerformed(ActionEvent e) {
        Browser b = this.model.getSelectedBrowser();
        if (b == null) {
            return;
        }
        TreeImageDisplay d = b.getLastSelectedDisplay();
        if (d == null) {
            return;
        }
        Object ho = d.getUserObject();
        if (ho instanceof ProjectData || ho instanceof CategoryGroupData || ho instanceof DatasetData) {
            this.model.addExistingObjects((DataObject)ho);
        } else if (ho instanceof CategoryData) {
            ClassifyCmd cmd = new ClassifyCmd(this.model, 0);
            cmd.execute();
        }
    }
}

