/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.ProjectData;

public class TreeViewerTranslator {
    public static final String DATE_NOT_AVAILABLE = "Date not available";
    public static final String ORPHANED_DATASETS = "Orphaned Datasets";
    public static final String ORPHANED_CATEGORIES = "Orphaned Categories";

    private static void formatToolTipFor(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        String toolTip = "";
        String title = null;
        if (node.getUserObject() instanceof ImageData) {
            Timestamp time = null;
            try {
                time = ((ImageData)node.getUserObject()).getInserted();
            }
            catch (Exception e) {
                // empty catch block
            }
            title = time == null ? DATE_NOT_AVAILABLE : TreeViewerTranslator.formatTime(time);
            toolTip = UIUtilities.formatToolTipText(title);
            node.setToolTip(toolTip);
        }
    }

    private static TreeCheckNode transformCategoryCheckNode(CategoryData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode category = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY), data.getName(), true);
        return category;
    }

    private static TreeCheckNode transformDatasetCheckNode(DatasetData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(IconManager.DATASET), data.getName(), true);
        return node;
    }

    private static TreeCheckNode transformImageCheckNode(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(IconManager.IMAGE), data.getName(), true);
        return node;
    }

    private static TreeCheckNode transformCategoryGroupCheckNode(CategoryGroupData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode group = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY_GROUP), data.getName(), false);
        Set categories = data.getCategories();
        for (CategoryData child : categories) {
            if (!TreeViewerTranslator.isWritable(child, userID, groupID)) continue;
            group.addChildDisplay(TreeViewerTranslator.transformCategoryCheckNode(child));
        }
        return group;
    }

    private static TreeImageDisplay transformDataset(DatasetData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet dataset = new TreeImageSet(data);
        Set images = data.getImages();
        if (images == null) {
            dataset.setNumberItems(-1);
        } else {
            dataset.setChildrenLoaded(Boolean.TRUE);
            dataset.setNumberItems(images.size());
            for (DataObject tmp : images) {
                ImageData child;
                if (!(tmp instanceof ImageData) || !TreeViewerTranslator.isReadable(child = (ImageData)tmp, userID, groupID)) continue;
                dataset.addChildDisplay(TreeViewerTranslator.transformImage(child));
            }
        }
        TreeViewerTranslator.formatToolTipFor(dataset);
        return dataset;
    }

    private static TreeImageDisplay transformProject(ProjectData data, Set datasets, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet project = new TreeImageSet(data);
        if (datasets != null) {
            project.setChildrenLoaded(Boolean.TRUE);
            for (DatasetData child : datasets) {
                if (!TreeViewerTranslator.isReadable(child, userID, groupID)) continue;
                project.addChildDisplay(TreeViewerTranslator.transformDataset(child, userID, groupID));
            }
            project.setNumberItems(datasets.size());
        } else {
            project.setChildrenLoaded(Boolean.FALSE);
            project.setNumberItems(0);
        }
        return project;
    }

    private static TreeImageDisplay transformCategory(CategoryData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet category = new TreeImageSet(data);
        Set images = data.getImages();
        if (images == null) {
            category.setNumberItems(-1);
        } else {
            category.setChildrenLoaded(Boolean.TRUE);
            category.setNumberItems(images.size());
            for (ImageData child : images) {
                if (!TreeViewerTranslator.isReadable(child, userID, groupID)) continue;
                category.addChildDisplay(TreeViewerTranslator.transformImage(child));
            }
        }
        return category;
    }

    private static TreeImageDisplay transformCategoryGroup(CategoryGroupData data, Set categories, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet group = new TreeImageSet(data);
        if (categories != null) {
            group.setChildrenLoaded(Boolean.TRUE);
            for (CategoryData child : categories) {
                if (!TreeViewerTranslator.isReadable(child, userID, groupID)) continue;
                group.addChildDisplay(TreeViewerTranslator.transformCategory(child, userID, groupID));
            }
            group.setNumberItems(categories.size());
        } else {
            group.setChildrenLoaded(Boolean.TRUE);
            group.setNumberItems(0);
        }
        return group;
    }

    private static TreeImageDisplay transformImage(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        TreeViewerTranslator.formatToolTipFor(node);
        return node;
    }

    public static Set transformHierarchy(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(dataObjects.size());
        Iterator i = dataObjects.iterator();
        TreeImageDisplay orphan = null;
        while (i.hasNext()) {
            TreeImageDisplay child;
            DataObject ho = (DataObject)i.next();
            if (!TreeViewerTranslator.isReadable(ho, userID, groupID)) continue;
            if (ho instanceof ProjectData) {
                results.add(TreeViewerTranslator.transformProject((ProjectData)ho, ((ProjectData)ho).getDatasets(), userID, groupID));
                continue;
            }
            if (ho instanceof CategoryGroupData) {
                results.add(TreeViewerTranslator.transformCategoryGroup((CategoryGroupData)ho, ((CategoryGroupData)ho).getCategories(), userID, groupID));
                continue;
            }
            if (ho instanceof ImageData) {
                results.add(TreeViewerTranslator.transformImage((ImageData)ho));
                continue;
            }
            if (ho instanceof DatasetData) {
                if (orphan == null) {
                    orphan = new TreeImageSet(ORPHANED_DATASETS);
                    results.add(orphan);
                }
                child = TreeViewerTranslator.transformDataset((DatasetData)ho, userID, groupID);
                ((TreeImageSet)orphan).addChildDisplay(child);
                continue;
            }
            if (!(ho instanceof CategoryData)) continue;
            if (orphan == null) {
                orphan = new TreeImageSet(ORPHANED_CATEGORIES);
                results.add(orphan);
            }
            child = TreeViewerTranslator.transformCategory((CategoryData)ho, userID, groupID);
            ((TreeImageSet)orphan).addChildDisplay(child);
        }
        if (orphan != null) {
            orphan.setExpanded(false);
        }
        return results;
    }

    public static Set transformContainers(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            if (ho instanceof ProjectData) {
                for (DataObject child : ((ProjectData)ho).getDatasets()) {
                    if (!TreeViewerTranslator.isReadable(child, userID, groupID)) continue;
                    results.add(TreeViewerTranslator.transformDataset((DatasetData)child, userID, groupID));
                }
                continue;
            }
            if (ho instanceof CategoryGroupData) {
                for (DataObject child : ((CategoryGroupData)ho).getCategories()) {
                    if (!TreeViewerTranslator.isReadable(child, userID, groupID)) continue;
                    results.add(TreeViewerTranslator.transformCategory((CategoryData)child, userID, groupID));
                }
                continue;
            }
            if (ho instanceof DatasetData) {
                if (!TreeViewerTranslator.isReadable(ho, userID, groupID)) continue;
                results.add(TreeViewerTranslator.transformDataset((DatasetData)ho, userID, groupID));
                continue;
            }
            if (!(ho instanceof CategoryData) || !TreeViewerTranslator.isReadable(ho, userID, groupID)) continue;
            results.add(TreeViewerTranslator.transformCategory((CategoryData)ho, userID, groupID));
        }
        return results;
    }

    public static Set refreshHierarchy(Map nodes, Map expandedTopNodes, long userID, long groupID) {
        if (nodes == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(nodes.size());
        Iterator i = nodes.keySet().iterator();
        List expanded = null;
        TreeImageDisplay orphan = null;
        while (i.hasNext()) {
            Set r;
            TreeImageDisplay display;
            DataObject ho = (DataObject)i.next();
            if (!TreeViewerTranslator.isReadable(ho, userID, groupID)) continue;
            if (ho instanceof ProjectData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(ProjectData.class);
                }
                display = TreeViewerTranslator.transformProject((ProjectData)ho, (Set)nodes.get(ho), userID, groupID);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(new Long(ho.getId())));
                }
                results.add(display);
                continue;
            }
            if (ho instanceof CategoryGroupData) {
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(CategoryGroupData.class);
                }
                display = TreeViewerTranslator.transformCategoryGroup((CategoryGroupData)ho, (Set)nodes.get(ho), userID, groupID);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(new Long(ho.getId())));
                }
                results.add(display);
                continue;
            }
            if (ho instanceof DatasetData) {
                if (orphan == null) {
                    orphan = new TreeImageSet(ORPHANED_DATASETS);
                    results.add(orphan);
                }
                if (expandedTopNodes != null) {
                    expanded = (List)expandedTopNodes.get(DatasetData.class);
                }
                r = (Set)nodes.get(ho);
                for (DatasetData element : r) {
                    display = TreeViewerTranslator.transformDataset(element, userID, groupID);
                    if (expanded != null) {
                        display.setExpanded(expanded.contains(new Long(ho.getId())));
                    }
                    ((TreeImageSet)orphan).addChildDisplay(display);
                }
                continue;
            }
            if (!(ho instanceof CategoryData)) continue;
            if (orphan == null) {
                orphan = new TreeImageSet(ORPHANED_CATEGORIES);
                results.add(orphan);
            }
            if (expandedTopNodes != null) {
                expanded = (List)expandedTopNodes.get(CategoryData.class);
            }
            if ((r = (Set)nodes.get(ho)) == null) continue;
            for (DatasetData element : r) {
                display = TreeViewerTranslator.transformCategory((CategoryData)element, userID, groupID);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(new Long(ho.getId())));
                }
                ((TreeImageSet)orphan).addChildDisplay(display);
            }
        }
        if (orphan != null) {
            orphan.setExpanded(false);
        }
        return results;
    }

    public static TreeImageDisplay transformDataObject(DataObject object, long userID, long groupID) {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (!TreeViewerTranslator.isReadable(object, userID, groupID)) {
            throw new IllegalArgumentException("Data object not readable.");
        }
        if (object instanceof ProjectData) {
            return TreeViewerTranslator.transformProject((ProjectData)object, ((ProjectData)object).getDatasets(), userID, groupID);
        }
        if (object instanceof DatasetData) {
            return TreeViewerTranslator.transformDataset((DatasetData)object, userID, groupID);
        }
        if (object instanceof CategoryData) {
            return TreeViewerTranslator.transformCategory((CategoryData)object, userID, groupID);
        }
        if (object instanceof CategoryGroupData) {
            return TreeViewerTranslator.transformCategoryGroup((CategoryGroupData)object, ((CategoryGroupData)object).getCategories(), userID, groupID);
        }
        if (object instanceof ImageData) {
            return TreeViewerTranslator.transformImage((ImageData)object);
        }
        throw new IllegalArgumentException("Data Type not supported.");
    }

    public static Set transformDataObjectsCheckNode(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            if (!TreeViewerTranslator.isWritable(ho, userID, groupID)) continue;
            if (ho instanceof CategoryGroupData) {
                Set categories = ((CategoryGroupData)ho).getCategories();
                if (categories == null || categories.size() == 0) continue;
                results.add(TreeViewerTranslator.transformCategoryGroupCheckNode((CategoryGroupData)ho, userID, groupID));
                continue;
            }
            if (ho instanceof CategoryData) {
                results.add(TreeViewerTranslator.transformCategoryCheckNode((CategoryData)ho));
                continue;
            }
            if (!(ho instanceof DatasetData)) continue;
            results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
        }
        return results;
    }

    public static Set transformIntoCheckNodes(Set paths, long userID, long groupID) {
        if (paths == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>();
        for (DataObject ho : paths) {
            if (!TreeViewerTranslator.isWritable(ho, userID, groupID)) continue;
            if (ho instanceof DatasetData) {
                results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
                continue;
            }
            if (ho instanceof CategoryData) {
                results.add(TreeViewerTranslator.transformCategoryCheckNode((CategoryData)ho));
                continue;
            }
            if (!(ho instanceof ImageData)) continue;
            results.add(TreeViewerTranslator.transformImageCheckNode((ImageData)ho));
        }
        return results;
    }

    public static boolean isReadable(Object ho, long userID, long groupID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        if (userID == data.getOwner().getId()) {
            return permissions.isUserRead();
        }
        return permissions.isGroupRead();
    }

    public static boolean isWritable(Object ho, long userID, long groupID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        if (userID == data.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }

    public static boolean isVisible(DataObject data, ExperimenterData loggedUser) {
        if (data == null) {
            return false;
        }
        return data instanceof ExperimenterData || data instanceof GroupData;
    }

    public static Timestamp getDefaultTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static String formatTime(Timestamp time) {
        if (time == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(time);
    }
}

