/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ImageData;

public class ThumbnailLoader
extends DataTreeViewerLoader {
    private static final int THUMB_MAX_WIDTH = 96;
    private static final int THUMB_MAX_HEIGHT = 96;
    private ImageData image;
    private CallHandle handle;

    public ThumbnailLoader(TreeViewer viewer, ImageData image) {
        super(viewer);
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        this.image = image;
    }

    public void load() {
        this.handle = this.dmView.loadThumbnail(this.image, 96, 96, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 2) {
            return;
        }
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            this.viewer.setThumbnail(td.getThumbnail());
        }
    }

    public void handleNullResult() {
    }

    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.viewer.setThumbnail(null);
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }
}

