/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;

public class RefreshDataLoader
extends DataBrowserLoader {
    private Class rootNodeType;
    private List expandedNodes;
    private Map expandedTopNodes;
    private CallHandle handle;

    private void checkClass(Class klass) {
        if (klass.equals(ProjectData.class) || klass.equals(CategoryGroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root node not supported.");
    }

    public RefreshDataLoader(Browser viewer, Class rootNodeType, List expandedNodes, Map expandedTopNodes) {
        super(viewer);
        this.checkClass(rootNodeType);
        this.rootNodeType = rootNodeType;
        this.expandedNodes = expandedNodes;
        this.expandedTopNodes = expandedTopNodes;
    }

    public void load() {
        this.handle = this.expandedNodes == null || this.expandedNodes.size() == 0 ? this.dmView.loadContainerHierarchy(this.rootNodeType, null, false, this.convertRootLevel(), this.viewer.getRootID(), this) : this.dmView.refreshHierarchy(this.rootNodeType, this.expandedNodes, this.convertRootLevel(), this.viewer.getRootID(), this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        HashMap map;
        if (this.viewer.getState() == 6) {
            return;
        }
        if (this.expandedNodes == null || this.expandedNodes.size() == 0) {
            Set set = (Set)result;
            Iterator j = set.iterator();
            map = new HashMap();
            HashSet<DataObject> children = null;
            while (j.hasNext()) {
                DataObject parent = (DataObject)j.next();
                if (parent instanceof ProjectData) {
                    children = ((ProjectData)parent).getDatasets();
                } else if (parent instanceof CategoryGroupData) {
                    children = ((CategoryGroupData)parent).getCategories();
                } else if (parent instanceof DatasetData) {
                    children = new HashSet<DataObject>(1);
                    children.add(parent);
                } else if (parent instanceof CategoryData) {
                    children = new HashSet(1);
                    children.add(parent);
                }
                map.put(parent, children);
            }
        } else {
            map = (HashMap)result;
        }
        this.viewer.setRefreshedHierarchy(map, this.expandedTopNodes);
    }
}

