/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.DatasetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagesInContainerLoader
extends DataBrowserLoader {
    public static final int DATASET = 0;
    public static final int CATEGORY = 1;
    private Set<Long> nodeIDs;
    private Class nodeType;
    private CallHandle handle;

    private boolean validate(Class type) {
        return type.equals(DatasetData.class) || type.equals(CategoryData.class);
    }

    public ImagesInContainerLoader(Browser viewer, Class nodeType, long nodeID) {
        super(viewer);
        if (!this.validate(nodeType)) {
            throw new IllegalArgumentException("Type not supported");
        }
        if (nodeID < 0L) {
            throw new IllegalArgumentException("RootId not valid");
        }
        this.nodeType = nodeType;
        this.nodeIDs = new HashSet<Long>(1);
        this.nodeIDs.add(new Long(nodeID));
    }

    public ImagesInContainerLoader(Browser viewer, Class nodeType, Set<Long> nodeIDs) {
        super(viewer);
        if (!this.validate(nodeType)) {
            throw new IllegalArgumentException("Type not supported");
        }
        if (nodeIDs == null || nodeIDs.size() == 0) {
            throw new IllegalArgumentException("RootIds not valid");
        }
        this.nodeType = nodeType;
        this.nodeIDs = nodeIDs;
    }

    @Override
    public void load() {
        this.handle = this.dmView.loadContainerHierarchy(this.nodeType, this.nodeIDs, true, this.convertRootLevel(), this.viewer.getRootID(), this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 6) {
            return;
        }
        Set nodes = (Set)result;
        Iterator i = nodes.iterator();
        HashSet images = new HashSet();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            if (object instanceof DatasetData) {
                images.addAll(((DatasetData)object).getImages());
                continue;
            }
            if (!(object instanceof CategoryData)) continue;
            images.addAll(((CategoryData)object).getImages());
        }
        this.viewer.setNodes(images);
    }
}

