/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;

public class HierarchyLoader
extends DataBrowserLoader {
    public static final int PROJECT = 0;
    public static final int CATEGORY_GROUP = 1;
    public static final int DATASET = 2;
    public static final int CATEGORY = 3;
    private boolean images;
    private boolean filter;
    private int containerType;
    private Class rootNodeType;
    private TreeImageSet parent;
    private CallHandle handle;

    private Class getClassType(int type) {
        switch (type) {
            case 0: {
                return ProjectData.class;
            }
            case 1: {
                return CategoryGroupData.class;
            }
            case 3: {
                return CategoryData.class;
            }
            case 2: {
                return DatasetData.class;
            }
        }
        return null;
    }

    private int convertType() {
        switch (this.containerType) {
            case 2: {
                return 201;
            }
            case 3: {
                return 202;
            }
        }
        throw new IllegalArgumentException("The only type supported by this methods are DATASET and CATEGORY.");
    }

    public HierarchyLoader(Browser viewer, int containerType, TreeImageSet parent) {
        this(viewer, containerType, true, false);
        this.parent = parent;
    }

    public HierarchyLoader(Browser viewer, int containerType) {
        this(viewer, containerType, false, false);
    }

    public HierarchyLoader(Browser viewer, int containerType, boolean images, boolean filter) {
        super(viewer);
        this.rootNodeType = this.getClassType(containerType);
        if (this.rootNodeType == null) {
            throw new IllegalArgumentException("Type not supported");
        }
        this.containerType = containerType;
        this.images = images;
        this.filter = filter;
    }

    public void load() {
        if (this.parent == null) {
            this.handle = this.dmView.loadContainerHierarchy(this.rootNodeType, null, this.images, this.convertRootLevel(), this.viewer.getRootID(), this);
        } else {
            HashSet<Long> ids = new HashSet<Long>(1);
            ids.add(new Long(this.parent.getUserObjectId()));
            this.handle = this.dmView.loadContainerHierarchy(this.rootNodeType, ids, this.images, this.convertRootLevel(), this.viewer.getRootID(), this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 6) {
            return;
        }
        if (this.filter) {
            this.viewer.setFilterNodes((Set)result, this.convertType());
        } else if (this.parent == null) {
            this.viewer.setContainerNodes((Set)result, this.parent);
        } else {
            Set nodes = (Set)result;
            Iterator i = nodes.iterator();
            Class<?> klass = this.parent.getUserObject().getClass();
            long id = this.parent.getUserObjectId();
            while (i.hasNext()) {
                DataObject object = (DataObject)i.next();
                if (!object.getClass().equals(klass) || object.getId() != id) continue;
                if (object instanceof DatasetData) {
                    this.viewer.setLeaves(((DatasetData)object).getImages(), this.parent);
                    continue;
                }
                if (!(object instanceof CategoryData)) continue;
                this.viewer.setLeaves(((CategoryData)object).getImages(), this.parent);
            }
        }
    }
}

