/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;

public abstract class EditorLoader
extends DSCallAdapter {
    protected final Editor viewer;
    protected final Registry registry;
    protected final DataManagerView dmView;
    protected final DataHandlerView dhView;

    protected EditorLoader(Editor viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = TreeViewerAgent.getRegistry();
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
    }

    public void onEnd() {
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data saving has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Saving Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

