/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import pojos.ExperimenterData;

public abstract class DataBrowserLoader
extends DSCallAdapter {
    protected final Browser viewer;
    protected final Registry registry;
    protected final DataManagerView dmView;

    protected Class convertRootLevel() {
        return ExperimenterData.class;
    }

    protected DataBrowserLoader(Browser viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = TreeViewerAgent.getRegistry();
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

