/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ContainerCounterLoader
extends DataBrowserLoader {
    private Set rootIDs;
    private CallHandle handle;

    public ContainerCounterLoader(Browser viewer, Set rootIDs) {
        super(viewer);
        if (rootIDs == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.rootIDs = rootIDs;
    }

    public void load() {
        this.handle = this.dmView.countContainerItems(this.rootIDs, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 6) {
            return;
        }
        Map map = (Map)fe.getPartialResult();
        if (map == null) {
            return;
        }
        if (map.size() == 1) {
            for (Long containerID : map.keySet()) {
                Integer value = (Integer)map.get(containerID);
                this.viewer.setContainerCountValue(containerID, value);
            }
        }
    }

    public void handleNullResult() {
    }
}

