/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.ClassifierLoader;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ExperimenterData;

public class ClassifierPathsLoader
extends ClassifierLoader {
    private Set imageIDs;
    private int mode;
    private long rootID;
    private CallHandle handle;

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Mode not supported.");
    }

    public ClassifierPathsLoader(Classifier viewer, Set imageIDs, int mode, long rootID) {
        super(viewer);
        if (imageIDs == null) {
            throw new IllegalArgumentException("No images.");
        }
        if (imageIDs.size() == 0) {
            throw new IllegalArgumentException("No images.");
        }
        this.checkMode(mode);
        this.rootID = rootID;
        this.imageIDs = imageIDs;
        this.mode = mode;
    }

    public void load() {
        switch (this.mode) {
            case 1: {
                this.handle = this.dmView.loadClassificationPaths(this.imageIDs, 0, ExperimenterData.class, this.rootID, this);
                break;
            }
            case 0: {
                this.handle = this.dmView.loadClassificationPaths(this.imageIDs, 2, ExperimenterData.class, this.rootID, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 4) {
            return;
        }
        this.viewer.setClassifications((Set)result);
    }
}

