/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.ClassifierLoader;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ImageData;

public class ClassificationSaver
extends ClassifierLoader {
    public static final int CLASSIFY = 0;
    public static final int DECLASSIFY = 1;
    private ImageData[] images;
    private int mode;
    private Set categories;
    private CallHandle handle;

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Classification mode not supported.");
    }

    private int convertMode() {
        switch (this.mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Classification mode not supported.");
    }

    public ClassificationSaver(Classifier viewer, int mode, ImageData[] images, Set categories) {
        super(viewer);
        this.checkMode(mode);
        if (images == null) {
            throw new IllegalArgumentException("No Image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No Image.");
        }
        if (categories == null || categories.size() == 0) {
            throw new IllegalArgumentException("No category selected.");
        }
        this.images = images;
        this.mode = mode;
        this.categories = categories;
    }

    public void load() {
        HashSet<ImageData> objects = new HashSet<ImageData>(this.images.length);
        for (int i = 0; i < this.images.length; ++i) {
            objects.add(this.images[i]);
        }
        switch (this.mode) {
            case 0: {
                this.handle = this.dmView.classify(objects, this.categories, this);
                break;
            }
            case 1: {
                this.handle = this.dmView.declassify(objects, this.categories, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 4) {
            return;
        }
        this.viewer.saveClassification(this.images, (Set)result, this.convertMode());
    }
}

