/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.util.ResourceBundleUtil;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.MeasurementBezierTool;
import org.openmicroscopy.shoola.agents.measurement.util.MeasurementConnectionTool;
import org.openmicroscopy.shoola.agents.measurement.util.MeasurementToolBarButtonFactory;
import org.openmicroscopy.shoola.agents.measurement.util.ObjectCreationTool;
import org.openmicroscopy.shoola.agents.measurement.util.PointCreationTool;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.figures.BezierAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.EllipseAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineConnectionAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.PointAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.RectAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    private static final HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private static final String CREATE_KEY = "create";
    private static final String BASE_NAME = "org.jhotdraw.draw.Labels";
    private static final Dimension HGLUE;
    private JToolBar toolBar;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private ObjectCreationTool ellipseTool;
    private ObjectCreationTool rectTool;
    private ObjectCreationTool lineTool;
    private ObjectCreationTool textTool;
    private PointCreationTool pointTool;
    private MeasurementBezierTool polygonTool;
    private MeasurementBezierTool polylineTool;
    private MeasurementConnectionTool connectionTool;

    private void initComponents() {
        this.ellipseTool = new ObjectCreationTool(new EllipseAnnotationFigure());
        this.rectTool = new ObjectCreationTool(new RectAnnotationFigure());
        this.textTool = new ObjectCreationTool(new MeasureTextFigure());
        this.lineTool = new ObjectCreationTool(new LineAnnotationFigure());
        this.connectionTool = new MeasurementConnectionTool((ConnectionFigure)new LineConnectionAnnotationFigure(), defaultAttributes);
        this.pointTool = new PointCreationTool(new PointAnnotationFigure());
        this.polygonTool = new MeasurementBezierTool(new BezierAnnotationFigure(true));
        this.polylineTool = new MeasurementBezierTool(new BezierAnnotationFigure(false));
        ButtonGroup group = new ButtonGroup();
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle((String)BASE_NAME);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.putClientProperty("toolButtonGroup", group);
        DrawingEditor editor = this.model.getDrawingEditor();
        MeasurementToolBarButtonFactory.addSelectionToolTo(this.toolBar, editor);
        this.toolBar.add(new JSeparator());
        this.toolBar.add(Box.createRigidArea(HGLUE));
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.rectTool, "createRectangle", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.ellipseTool, "createEllipse", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.pointTool, "createEllipse", labels);
        Component component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)component;
            IconManager icons = IconManager.getInstance();
            button.setIcon(icons.getIcon(23));
        }
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.lineTool, "createLine", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.connectionTool, "createLineConnection", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.polylineTool, "createScribble", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.polygonTool, "createPolygon", labels);
        MeasurementToolBarButtonFactory.addToolTo(this.toolBar, editor, (Tool)this.textTool, "createText", labels);
        this.createSingleFigure(false);
    }

    private JToolBar buildControlsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton button = new JButton(this.controller.getAction(MeasurementViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.LOAD));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        bar.add(new JSeparator());
        return bar;
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.buildControlsBar());
        p.add(Box.createHorizontalStrut(5));
        p.add(this.toolBar);
        this.setLayout(new FlowLayout(0));
        this.add(p);
    }

    public void createSingleFigure(boolean option) {
        this.ellipseTool.setResetToSelect(option);
        this.rectTool.setResetToSelect(option);
        this.textTool.setResetToSelect(option);
        this.lineTool.setResetToSelect(option);
        this.pointTool.setResetToSelect(option);
        this.polygonTool.setResetToSelect(option);
        this.polylineTool.setResetToSelect(option);
    }

    ToolBar(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    static {
        defaultAttributes.put(AttributeKeys.FILL_COLOR, IOConstants.DEFAULT_FILL_COLOUR);
        defaultAttributes.put(AttributeKeys.STROKE_COLOR, IOConstants.DEFAULT_STROKE_COLOUR);
        defaultAttributes.put(AttributeKeys.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        defaultAttributes.put(AttributeKeys.FONT_SIZE, new Double(10.0));
        defaultAttributes.put(AttributeKeys.FONT_BOLD, false);
        defaultAttributes.put(AttributeKeys.STROKE_WIDTH, new Double(1.0));
        defaultAttributes.put(AttributeKeys.TEXT, "Text");
        defaultAttributes.put(DrawingAttributes.MEASUREMENTTEXT_COLOUR, IOConstants.DEFAULT_MEASUREMENT_TEXT_COLOUR);
        defaultAttributes.put(DrawingAttributes.SHOWMEASUREMENT, new Boolean(false));
        defaultAttributes.put(DrawingAttributes.SHOWTEXT, new Boolean(false));
        HGLUE = new Dimension(5, 5);
    }
}

