/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusBar
extends JPanel {
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final Dimension PROGRESSBAR_SIZE = new Dimension(30, 8);
    private JLabel status;
    private JButton statusButton;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.statusButton = new JButton(icons.getIcon(14));
        this.statusButton.setContentAreaFilled(false);
        this.statusButton.setBorder(null);
        UIUtilities.unifiedButtonLookAndFeel(this.statusButton);
        this.status = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressLabel = new JLabel(icons.getIcon(IconManager.PROGRESS));
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.statusButton);
        p.add(Box.createRigidArea(H_SPACER_SIZE));
        p.add(this.status);
        this.add(UIUtilities.buildComponentPanel(p));
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(this.progressBar);
        progressPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        progressPanel.add(this.progressLabel);
        progressPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.progressBar.setPreferredSize(PROGRESSBAR_SIZE);
        this.progressBar.setSize(PROGRESSBAR_SIZE);
    }

    StatusBar() {
        this.initComponents();
        this.buildUI();
    }

    void setStatus(String s) {
        this.status.setText(s);
    }
}

