/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.agents.measurement.util.ROIAssistantCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistantModel;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

class ROIAssistantTable
extends JTable {
    private static final int COLUMNWIDTH = 32;
    private static final int LEADERCOLUMN_WIDTH = 80;
    private static final Color GRIDCOLOUR = new Color(180, 213, 255);
    private int columnWidth;
    private int leaderColumnWidth;

    ROIAssistantTable(ROIAssistantModel model) {
        int w;
        this.setModel(model);
        this.setAutoResizeMode(0);
        int columnWidth = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            w = metrics.stringWidth(model.getColumnName(i));
            columnWidth = Math.max(w, 32);
        }
        w = metrics.stringWidth(model.getColumnName(0));
        this.leaderColumnWidth = Math.max(w, 80);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            int width = columnWidth;
            if (i == 0) {
                width = this.leaderColumnWidth;
            }
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(columnWidth);
        this.setGridColor(GRIDCOLOUR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(true);
    }

    int getColumnWidth() {
        return this.columnWidth;
    }

    int getLeaderColumnWidth() {
        return this.leaderColumnWidth;
    }

    ROIShape getShapeAt(int row, int col) {
        return ((ROIAssistantModel)this.getModel()).getShapeAt(row, col);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return new ROIAssistantCellRenderer();
    }
}

