/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

class ROIAssistantModel
extends AbstractTableModel {
    private ROI currentROI;
    private Coord3D currentPlane;
    private int numColumns;
    private int numRows;
    private TreeMap<Coord3D, String> shapeMap;
    private ArrayList<String> columnNames;

    private void populateShapeMap() {
        this.shapeMap.clear();
        TreeMap<Coord3D, ROIShape> list = this.currentROI.getShapes();
        for (ROIShape shape : list.values()) {
            Coord3D coord = shape.getCoord3D();
            this.numRows = Math.max(this.numRows, coord.getZSection());
            this.shapeMap.put(coord, shape.getFigure().getType());
        }
    }

    ROIAssistantModel(int numCol, int numRow, Coord3D currentPlane, ROI roi) {
        this.setColumnCount(numCol + 1);
        this.setRowCount(numRow);
        this.columnNames = new ArrayList();
        this.currentPlane = currentPlane;
        this.currentROI = roi;
        this.columnNames.add("Z Section\\Time");
        this.shapeMap = new TreeMap(new Coord3D());
        for (int i = 0; i < numCol; ++i) {
            this.columnNames.add(i + 1 + "");
        }
        this.populateShapeMap();
    }

    ROIShape getShapeAt(int zSection, int timePoint) {
        try {
            int translateZ = this.getRowCount() - zSection;
            return this.currentROI.getShape(new Coord3D(translateZ - 1, timePoint - 1));
        }
        catch (NoSuchROIException e) {
            return null;
        }
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    public int getRowCount() {
        return this.numRows;
    }

    public void setValueAt(Object value, int col, int row) {
    }

    public Object getValueAt(int zSection, int timePoint) {
        int translateZ = this.getRowCount() - zSection;
        if (timePoint == 0) {
            return translateZ + "";
        }
        try {
            ROIShape shape = this.currentROI.getShape(new Coord3D(translateZ - 1, timePoint - 1));
            if (shape == null) {
                return null;
            }
            return shape.getFigure().getType();
        }
        catch (NoSuchROIException e) {
            return null;
        }
    }

    public void setColumnCount(int col) {
        this.numColumns = col;
    }

    public void setRowCount(int row) {
        this.numRows = row;
    }
}

