/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.ROITableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

class ObjectManager
extends JPanel {
    private static int COLUMNWIDTH = 32;
    private static List<String> columnNames = new ArrayList<String>(2);
    private static final String NAME = "Manager";
    private ObjectTable objectsTable;
    private MeasurementViewerUI view;
    private MeasurementViewerModel model;
    private ListSelectionListener listener;

    private void initComponents() {
        this.objectsTable = new ObjectTable(new ROIFigureTableModel(columnNames));
        this.objectsTable.setSelectionMode(2);
        this.objectsTable.setRowSelectionAllowed(true);
        this.objectsTable.getTableHeader().setReorderingAllowed(false);
        this.listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int index = lsm.getMinSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    ROIFigureTableModel m = (ROIFigureTableModel)ObjectManager.this.objectsTable.getModel();
                    ROIFigure figure = (ROIFigure)m.getFigureAt(index);
                    ObjectManager.this.view.selectFigure(figure);
                }
            }
        };
        this.objectsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int col = ObjectManager.this.objectsTable.getSelectedColumn();
                int row = ObjectManager.this.objectsTable.getSelectedRow();
                Object value = ObjectManager.this.objectsTable.getValueAt(row, col);
                if (value instanceof Boolean) {
                    ObjectManager.this.toggleValue();
                }
            }
        });
        this.objectsTable.getSelectionModel().addListSelectionListener(this.listener);
    }

    private void toggleValue() {
        int col = this.objectsTable.getSelectedColumn();
        int row = this.objectsTable.getSelectedRow();
        TableModel tm = this.objectsTable.getModel();
        Boolean value = (Boolean)tm.getValueAt(row, col);
        boolean newValue = value == false;
        tm.setValueAt(new Boolean(newValue), row, col);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.objectsTable), "Center");
    }

    ObjectManager(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(2);
    }

    void addFigures(Collection l) {
        Iterator i = l.iterator();
        ROIFigureTableModel tm = (ROIFigureTableModel)this.objectsTable.getModel();
        try {
            while (i.hasNext()) {
                ROI roi = (ROI)i.next();
                tm.addFigure(roi.getFigure(this.model.getCurrentView()));
            }
            this.objectsTable.setModel(tm);
            this.objectsTable.repaint();
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figures addition " + e);
        }
    }

    void setSelectedFigures(Collection l, boolean clear) {
        Iterator i = l.iterator();
        ROIFigureTableModel tm = (ROIFigureTableModel)this.objectsTable.getModel();
        ListSelectionModel lsm = this.objectsTable.getSelectionModel();
        if (clear) {
            lsm.clearSelection();
        }
        lsm.removeListSelectionListener(this.listener);
        try {
            while (i.hasNext()) {
                ROI roi = (ROI)i.next();
                ROIFigure figure = roi.getFigure(this.model.getCurrentView());
                int row = tm.getRowFromFigure(figure);
                this.objectsTable.addRowSelectionInterval(row, row);
            }
            this.objectsTable.repaint();
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figure selection " + e);
        }
        lsm.addListSelectionListener(this.listener);
    }

    void removeFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        ROIFigureTableModel m = (ROIFigureTableModel)this.objectsTable.getModel();
        m.removeFigure(figure);
        this.objectsTable.setModel(m);
        this.objectsTable.repaint();
    }

    void update() {
        this.objectsTable.repaint();
    }

    void rebuildTable() {
        ROIFigureTableModel tm = (ROIFigureTableModel)this.objectsTable.getModel();
        tm.clear();
        TreeMap roiList = this.model.getROI();
        for (ROI roi : roiList.values()) {
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            Iterator<ROIShape> shapeIterator = shapeList.values().iterator();
            while (shapeIterator.hasNext()) {
                tm.addFigure(shapeIterator.next().getFigure());
            }
        }
    }

    static {
        columnNames.add("ID");
        columnNames.add("Z Section");
        columnNames.add("Time Point");
        columnNames.add("Shape");
        columnNames.add("Text");
        columnNames.add("Visible");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ROIFigureTableModel
    extends AbstractTableModel {
        private List<String> columnNames;
        private List<ROIFigure> data;

        public void clear() {
            int size = this.data.size();
            this.data.clear();
            this.fireTableRowsDeleted(0, size);
        }

        private Object mapFigureToValue(int row, int col) {
            if (row < 0) {
                return null;
            }
            ROIFigure fig = this.data.get(row);
            switch (col) {
                case 0: {
                    return fig.getROI().getID();
                }
                case 1: {
                    return fig.getROIShape().getCoord3D().getZSection() + 1;
                }
                case 2: {
                    return fig.getROIShape().getCoord3D().getTimePoint() + 1;
                }
                case 3: {
                    return fig.getType();
                }
                case 4: {
                    return AttributeKeys.TEXT.get((Figure)fig);
                }
                case 5: {
                    return fig.isVisible();
                }
            }
            return null;
        }

        private void mapValueToFigure(Object value, int row, int col) {
            Figure fig = this.data.get(row);
            switch (col) {
                case 0: 
                case 1: {
                    break;
                }
                case 4: {
                    AttributeKeys.TEXT.set(fig, (Object)((String)value));
                    break;
                }
                case 5: {
                    fig.setVisible(((Boolean)value).booleanValue());
                }
            }
        }

        ROIFigureTableModel(List<String> columnNames) {
            if (columnNames == null) {
                throw new IllegalArgumentException("No column's names specified.");
            }
            this.columnNames = columnNames;
            this.data = new ArrayList<ROIFigure>();
        }

        void addFigure(ROIFigure figure) {
            if (figure == null) {
                return;
            }
            this.data.add(figure);
            this.fireTableDataChanged();
        }

        void removeFigure(ROIFigure figure) {
            this.data.remove(figure);
        }

        Figure getFigureAt(int row) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            return this.data.get(row);
        }

        int getRowFromFigure(ROIFigure figure) {
            if (figure == null) {
                return -1;
            }
            for (int i = 0; i < this.data.size(); ++i) {
                if (figure != this.data.get(i)) continue;
                return i;
            }
            return -1;
        }

        void updateModel(ROIFigure figure) {
            int i = this.getRowFromFigure(figure);
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.setValueAt(this.mapFigureToValue(i, j), i, j);
            }
            this.fireTableDataChanged();
        }

        void update() {
            for (int i = 0; i < this.data.size(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    this.setValueAt(this.mapFigureToValue(i, j), i, j);
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.mapValueToFigure(value, row, col);
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.mapFigureToValue(row, column);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }
    }

    class ObjectTable
    extends JTable {
        ObjectTable(ROIFigureTableModel model) {
            super(model);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return new ROITableCellRenderer();
        }
    }
}

