/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.ROITableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

class ObjectInspector
extends JPanel {
    private static List<String> columnNames = new ArrayList<String>(2);
    private static final String NAME = "Inspector";
    private JTable fieldTable;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;

    private void initComponents() {
        ArrayList<AttributeField> l = new ArrayList<AttributeField>();
        l.add(new AttributeField(AttributeKeys.TEXT, "Text", true));
        l.add(new AttributeField(DrawingAttributes.SHOWTEXT, "Show Text", false));
        l.add(new AttributeField(DrawingAttributes.SHOWMEASUREMENT, "Show Measurements", false));
        l.add(new AttributeField(AttributeKeys.STROKE_WIDTH, "Line Width", true));
        l.add(new AttributeField(AttributeKeys.FONT_SIZE, "Font Size", true));
        l.add(new AttributeField(AttributeKeys.TEXT_COLOR, "Font Colour", false));
        l.add(new AttributeField(AttributeKeys.FILL_COLOR, "Fill Colour", false));
        l.add(new AttributeField(AttributeKeys.STROKE_COLOR, "Line Colour", false));
        l.add(new AttributeField(DrawingAttributes.MEASUREMENTTEXT_COLOUR, "Measurement Text Colour", false));
        this.fieldTable = new FigureTable(new FigureTableModel(l, columnNames));
        this.fieldTable.getTableHeader().setReorderingAllowed(false);
        this.fieldTable.setRowHeight(25);
        this.fieldTable.setSelectionMode(0);
        this.fieldTable.setCellSelectionEnabled(true);
        this.fieldTable.setColumnSelectionAllowed(true);
        this.fieldTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                    int row = ObjectInspector.this.fieldTable.getSelectedRow();
                    Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                } else if (e.getClickCount() > 1) {
                    e.consume();
                    int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                    int row = ObjectInspector.this.fieldTable.getSelectedRow();
                    Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                    if (value instanceof Color) {
                        ObjectInspector.this.controller.showColorPicker((Color)value);
                    }
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                }
            }
        });
    }

    private void toggleValue() {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        Boolean value = (Boolean)this.fieldTable.getModel().getValueAt(row, col);
        boolean newValue = value == false;
        this.fieldTable.getModel().setValueAt(new Boolean(newValue), row, col);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.fieldTable), "Center");
    }

    ObjectInspector(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(1);
    }

    void setCellColor(Color c) {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        this.fieldTable.getModel().setValueAt(c, row, col);
    }

    void setModelData(Figure figure) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        tableModel.setData(figure);
        this.fieldTable.setModel(tableModel);
        this.fieldTable.repaint();
    }

    void setSelectedFigures(Collection l) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        Iterator i = l.iterator();
        try {
            while (i.hasNext()) {
                ROI roi = (ROI)i.next();
                ROIShape shape = roi.getShape(this.model.getCurrentView());
                tableModel.setData(shape.getFigure());
                this.fieldTable.setModel(tableModel);
                this.fieldTable.repaint();
            }
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figures selection" + e);
        }
    }

    static {
        columnNames.add("Field");
        columnNames.add("Value");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FigureTableModel
    extends AbstractTableModel {
        private static final String NA = "N/A";
        private Figure figure;
        private List<String> columnNames;
        private List<AttributeKey> keys;
        private List values;
        private List<AttributeField> fieldList;

        public FigureTableModel(List<AttributeField> fieldList, List<String> columnNames) {
            if (fieldList == null) {
                throw new IllegalArgumentException("No fields specified.");
            }
            if (columnNames == null) {
                throw new IllegalArgumentException("No column's names specified.");
            }
            this.fieldList = fieldList;
            this.columnNames = columnNames;
            this.keys = new ArrayList<AttributeKey>();
            this.values = new ArrayList();
        }

        public void setData(Figure figure) {
            if (figure == null) {
                throw new IllegalArgumentException("No figure.");
            }
            this.figure = figure;
            this.keys.clear();
            this.values.clear();
            for (AttributeField fieldName : this.fieldList) {
                boolean found = false;
                for (AttributeKey key : figure.getAttributes().keySet()) {
                    if (!key.equals((Object)fieldName.getKey())) continue;
                    this.keys.add(key);
                    this.values.add(figure.getAttribute(key));
                    found = true;
                    break;
                }
                if (found) continue;
                this.keys.add(fieldName.getKey());
                this.values.add(NA);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.keys.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.fieldList.get(rowIndex).getName();
            }
            return this.values.get(rowIndex);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                return;
            }
            AttributeKey key = this.keys.get(row);
            if (this.figure.getAttribute(key) instanceof Double) {
                this.figure.setAttribute(this.keys.get(row), (Object)new Double((String)value));
            } else if (this.figure.getAttribute(key) instanceof Boolean) {
                this.figure.setAttribute(this.keys.get(row), value);
            } else {
                this.figure.setAttribute(this.keys.get(row), value);
            }
            this.values.set(row, value);
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (this.values.get(row) instanceof String && this.values.get(row).equals(NA)) {
                return false;
            }
            return this.fieldList.get(row).isEditable();
        }
    }

    class FigureTable
    extends JTable {
        FigureTable(FigureTableModel model) {
            super(model);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return new ROITableCellRenderer();
        }
    }
}

