/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.view.GraphPane;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityView;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementResults;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectInspector;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectManager;
import org.openmicroscopy.shoola.agents.measurement.view.ROIDrawingView;
import org.openmicroscopy.shoola.agents.measurement.view.StatusBar;
import org.openmicroscopy.shoola.agents.measurement.view.ToolBar;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class MeasurementViewerUI
extends TopWindow {
    static final String RETRIEVE_MSG = "Cannot retrieve the ROI";
    static final String CREATE_MSG = "Cannot create the ROI";
    static final String DELETE_MSG = "Cannot delete the ROI";
    static final String DEFAULT_MSG = "";
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 300);
    private static final String WINDOW_TITLE = "Measurement Tool ";
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private LoadingWindow loadingWindow = new LoadingWindow(this);
    private ToolBar toolBar;
    private ObjectInspector roiInspector;
    private ObjectManager roiManager;
    private MeasurementResults roiResults;
    private GraphPane graphPane;
    private IntensityView intensityView;
    private JTabbedPane tabs;
    private StatusBar statusBar;

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu());
        menuBar.add(this.createOptionsMenu());
        return menuBar;
    }

    private JMenu createControlsMenu() {
        JMenu menu = new JMenu("Controls");
        menu.setMnemonic(67);
        MeasurementViewerAction a = this.controller.getAction(MeasurementViewerControl.LOAD);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.SAVE);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        return menu;
    }

    private JMenu createOptionsMenu() {
        JMenu menu = new JMenu("Options");
        ButtonGroup displayUnits = new ButtonGroup();
        menu.setMnemonic(79);
        JMenu subMenu = new JMenu("Units");
        MeasurementViewerAction a = this.controller.getAction(MeasurementViewerControl.IN_MICRONS);
        JCheckBoxMenuItem inMicronsMenu = new JCheckBoxMenuItem(a);
        inMicronsMenu.setText(a.getName());
        displayUnits.add(inMicronsMenu);
        subMenu.add(inMicronsMenu);
        a = this.controller.getAction(MeasurementViewerControl.IN_PIXELS);
        JCheckBoxMenuItem inPixelsMenu = new JCheckBoxMenuItem(a);
        inPixelsMenu.setText(a.getName());
        displayUnits.add(inPixelsMenu);
        subMenu.add(inPixelsMenu);
        inPixelsMenu.setSelected(true);
        menu.add(subMenu);
        ButtonGroup createFigureGroup = new ButtonGroup();
        JMenu creationMenu = new JMenu("Figure Creation");
        a = this.controller.getAction(MeasurementViewerControl.CREATESINGLEFIGURE);
        JCheckBoxMenuItem createSingleFigure = new JCheckBoxMenuItem(a);
        createSingleFigure.setText(a.getName());
        createFigureGroup.add(createSingleFigure);
        creationMenu.add(createSingleFigure);
        a = this.controller.getAction(MeasurementViewerControl.CREATEMULTIPLEFIGURE);
        JCheckBoxMenuItem createMultipleFigure = new JCheckBoxMenuItem(a);
        createMultipleFigure.setText(a.getName());
        createFigureGroup.add(createMultipleFigure);
        creationMenu.add(createMultipleFigure);
        createMultipleFigure.setSelected(true);
        menu.add(creationMenu);
        return menu;
    }

    private void initComponents() {
        this.statusBar = new StatusBar();
        this.toolBar = new ToolBar(this.controller, this.model);
        this.roiInspector = new ObjectInspector(this.controller, this.model);
        this.roiManager = new ObjectManager(this, this.model);
        this.roiResults = new MeasurementResults(this.controller, this.model, this);
        this.graphPane = new GraphPane(this.controller, this.model);
        this.intensityView = new IntensityView(this.controller, this.model);
        this.tabs = new JTabbedPane(1, 0);
        this.addTabbedPaneListener();
        this.tabs.setAlignmentX(0.0f);
    }

    private void addTabbedPaneListener() {
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                if (MeasurementViewerUI.this.inDataView()) {
                    MeasurementViewerUI.this.controller.analyseSelectedFigures();
                }
            }
        });
    }

    private void buildGUI() {
        this.setJMenuBar(this.createMenuBar());
        this.tabs.addTab(this.roiInspector.getComponentName(), this.roiInspector.getComponentIcon(), this.roiInspector);
        this.tabs.addTab(this.roiManager.getComponentName(), this.roiManager.getComponentIcon(), this.roiManager);
        this.tabs.addTab(this.roiResults.getComponentName(), this.roiResults.getComponentIcon(), this.roiResults);
        this.tabs.addTab(this.graphPane.getComponentName(), this.graphPane.getComponentIcon(), this.graphPane);
        this.tabs.addTab(this.intensityView.getComponentName(), this.intensityView.getComponentIcon(), this.intensityView);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.tabs, "Center");
        container.add((Component)this.statusBar, "South");
    }

    public boolean inDataView() {
        return this.inIntensityView() || this.inGraphView();
    }

    public boolean inGraphView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.graphPane.getComponentName());
    }

    public boolean inIntensityView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.intensityView.getComponentName());
    }

    MeasurementViewerUI(String title) {
        super(WINDOW_TITLE + title);
    }

    void initialize(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = controller;
        controller.attachListeners();
        this.initComponents();
        this.buildGUI();
    }

    LoadingWindow getLoadingWindow() {
        return this.loadingWindow;
    }

    void setCellColor(Color color) {
        if (this.roiInspector != null) {
            this.roiInspector.setCellColor(color);
        }
    }

    void selectFigure(long ROIid, int t, int z) {
        try {
            ROI roi = this.model.getROI(ROIid);
            ROIFigure fig = roi.getFigure(new Coord3D(z, t));
            this.selectFigure(fig);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
    }

    void selectFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        Coord3D coord3D = figure.getROIShape().getCoord3D();
        if (coord3D == null) {
            return;
        }
        if (!coord3D.equals(this.model.getCurrentView())) {
            this.model.setPlane(coord3D.getZSection(), coord3D.getTimePoint());
            SelectPlane request = new SelectPlane(this.model.getPixelsID(), coord3D.getZSection(), coord3D.getTimePoint());
            EventBus bus = MeasurementAgent.getRegistry().getEventBus();
            bus.post(request);
            this.updateDrawingArea();
        }
        ROIDrawingView dv = this.model.getDrawingView();
        dv.clearSelection();
        dv.addToSelection(figure);
        Collection figures = dv.getSelectedFigures();
        if (figures == null) {
            return;
        }
        Iterator i = figures.iterator();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        try {
            while (i.hasNext()) {
                ROIFigure f = (ROIFigure)i.next();
                ROI roi = this.model.getROI(f.getROI().getID());
                if (roi == null) continue;
                roiList.add(roi);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        dv.grabFocus();
        this.roiInspector.setSelectedFigures(roiList);
        this.roiManager.setSelectedFigures(roiList, false);
    }

    void setSelectedFigures(Collection figures) {
        if (this.model.getState() != 6) {
            return;
        }
        if (figures == null) {
            return;
        }
        Iterator i = figures.iterator();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        try {
            while (i.hasNext()) {
                ROIFigure figure = (ROIFigure)i.next();
                ROI roi = this.model.getROI(figure.getROI().getID());
                if (roi == null) continue;
                roiList.add(roi);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.roiInspector.setSelectedFigures(roiList);
        this.roiManager.setSelectedFigures(roiList, true);
    }

    void removeROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        try {
            this.model.removeROIShape(figure.getROI().getID());
            this.roiManager.removeFigure(figure);
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    void addROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        ROI roi = null;
        try {
            roi = this.model.createROI(figure);
        }
        catch (Exception e) {
            this.handleROIException(e, CREATE_MSG);
        }
        if (roi == null) {
            return;
        }
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        roiList.add(roi);
        this.roiManager.addFigures(roiList);
    }

    void onAttributeChanged(Figure figure) {
        if (this.model.getState() != 6) {
            return;
        }
        if (figure == null) {
            return;
        }
        this.roiInspector.setModelData(figure);
        this.roiManager.update();
    }

    Drawing getDrawing() {
        return this.model.getDrawing();
    }

    ROIDrawingView getDrawingView() {
        return this.model.getDrawingView();
    }

    void rebuildManagerTable() {
        this.roiManager.rebuildTable();
    }

    void refreshResultsTable() {
        this.roiResults.refreshResults();
    }

    boolean saveResultsTable() throws IOException {
        return this.roiResults.saveResults();
    }

    void showResultsWizard() {
        this.roiResults.showResultsWizard();
    }

    void handleROIException(Exception e, String text) {
        Registry reg = MeasurementAgent.getRegistry();
        if (e instanceof ROICreationException || e instanceof NoSuchROIException) {
            reg.getLogger().error((Object)this, "Problem while handling ROI " + e.getMessage());
            this.statusBar.setStatus(text);
        } else {
            String s = "An unexpected error occured while handling ROI ";
            reg.getLogger().error((Object)this, s + e.getMessage());
            reg.getUserNotifier().notifyError("ROI", s, e);
        }
    }

    void updateDrawingArea() {
        Drawing drawing = this.model.getDrawing();
        drawing.removeDrawingListener((DrawingListener)this.controller);
        drawing.clear();
        ShapeList list = null;
        try {
            list = this.model.getShapeList();
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        if (list != null) {
            TreeMap<Long, ROIShape> map = list.getList();
            for (ROIShape shape : map.values()) {
                if (shape == null) continue;
                drawing.add((Figure)shape.getFigure());
            }
        }
        this.setStatus(DEFAULT_MSG);
        this.model.getDrawingView().setDrawing(drawing);
        drawing.addDrawingListener((DrawingListener)this.controller);
    }

    void propagateShape(ROIShape shape, int timePoint, int zSection) {
        try {
            this.model.propagateShape(shape, timePoint, zSection);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus(DEFAULT_MSG);
        this.rebuildManagerTable();
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) {
        try {
            this.model.deleteShape(shape, timePoint, zSection);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus(DEFAULT_MSG);
        this.rebuildManagerTable();
    }

    void setStatus(String text) {
        this.statusBar.setStatus(text);
    }

    void displayAnalysisResults() {
        if (this.inGraphView()) {
            this.graphPane.displayAnalysisResults();
        }
        if (this.inIntensityView()) {
            this.intensityView.displayAnalysisResults();
        }
    }

    void createSingleFigure(boolean createSingleFig) {
        this.toolBar.createSingleFigure(createSingleFig);
    }

    public void setOnScreen() {
        if (this.model != null) {
            this.setSize(DEFAULT_SIZE);
            UIUtilities.setLocationRelativeTo(this.model.getRequesterBounds(), (Component)this);
        } else {
            this.pack();
            UIUtilities.incrementRelativeToAndShow(null, this);
        }
    }
}

