/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.Analyser;
import org.openmicroscopy.shoola.agents.measurement.ChannelMetadataLoader;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.PixelsLoader;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.ROIDrawingView;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerModel {
    private long imageID;
    private long pixelsID;
    private String name;
    private Rectangle requesterBounds;
    private int state;
    private DefaultDrawing drawing;
    private DrawingEditor drawingEditor;
    private ROIDrawingView drawingView;
    private ROIComponent roiComponent;
    private Coord3D currentPlane;
    private PixelsDimensions pixelsDims;
    private Pixels pixels;
    private double magnification;
    private String roiFileName;
    private Map activeChannels;
    private Map analysisResults;
    private ChannelMetadata[] metadata;
    private MeasurementViewerLoader currentLoader;
    private MeasurementViewer component;

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)MeasurementAgent.getRegistry().lookup("/current_user/details");
    }

    MeasurementViewerModel(long imageID, long pixelsID, String name, Rectangle bounds) {
        this.imageID = imageID;
        this.pixelsID = pixelsID;
        this.name = name;
        this.requesterBounds = bounds;
        this.state = 1;
        this.drawingEditor = new DefaultDrawingEditor();
        this.drawing = new DefaultDrawing();
        this.drawingView = new ROIDrawingView();
        this.roiComponent = new ROIComponent();
        this.drawingView.setDrawing((Drawing)this.drawing);
        this.drawingEditor.add((DrawingView)this.drawingView);
        this.roiFileName = imageID + ".xml";
    }

    void initialize(MeasurementViewer component) {
        this.component = component;
    }

    void setPlane(int z, int t) {
        this.currentPlane = new Coord3D(z, t);
    }

    boolean isSameDisplay(MeasurementViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.pixelsID == this.pixelsID && other.imageID == this.imageID;
    }

    long getImageID() {
        return this.imageID;
    }

    long getPixelsID() {
        return this.pixelsID;
    }

    String getImageName() {
        return this.name;
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    int getState() {
        return this.state;
    }

    DrawingEditor getDrawingEditor() {
        return this.drawingEditor;
    }

    Drawing getDrawing() {
        return this.drawing;
    }

    void discard() {
        this.cancel();
        this.state = 7;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.state = 6;
    }

    void firePixelsLoading() {
        this.state = 2;
        this.currentLoader = new PixelsLoader(this.component, this.pixelsID);
        this.currentLoader.load();
    }

    void fireROILoading(String fileName) {
        this.state = 3;
        if (fileName == null) {
            fileName = this.roiFileName;
        }
        this.component.setROI(IOUtil.readFile(fileName));
    }

    int getDefaultZ() {
        return this.currentPlane.getZSection();
    }

    int getDefaultT() {
        return this.currentPlane.getTimePoint();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnification(double magnification) {
        this.magnification = magnification;
        if (this.state != 1) {
            this.drawingView.setScaleFactor(magnification, new Dimension(this.getSizeX(), this.getSizeY()));
        } else {
            this.drawingView.setScaleFactor(magnification);
        }
    }

    void setROI(InputStream input) throws Exception {
        if (input != null) {
            List<ROI> roiList = this.roiComponent.loadROI(input);
            this.component.attachListeners(roiList);
        }
        this.state = 6;
    }

    TreeMap getROI() {
        return this.roiComponent.getROIMap();
    }

    Coord3D getCurrentView() {
        return this.currentPlane;
    }

    float getPixelSizeX() {
        return this.pixelsDims.getSizeX().floatValue();
    }

    float getPixelSizeY() {
        return this.pixelsDims.getSizeY().floatValue();
    }

    float getPixelSizeZ() {
        return this.pixelsDims.getSizeZ().floatValue();
    }

    int getNumZSections() {
        return this.pixels.getSizeZ();
    }

    int getNumTimePoints() {
        return this.pixels.getSizeT();
    }

    int getSizeX() {
        return this.pixels.getSizeX();
    }

    int getSizeY() {
        return this.pixels.getSizeY();
    }

    ROIDrawingView getDrawingView() {
        return this.drawingView;
    }

    Collection<ROI> getSelectedROI() {
        Collection selectedFigs = this.drawingView.getSelectedFigures();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        for (ROIFigure fig : selectedFigs) {
            roiList.add(fig.getROI());
        }
        return roiList;
    }

    void removeROIShape(long id) throws NoSuchROIException {
        this.roiComponent.deleteShape(id, this.getCurrentView());
    }

    ROI getROI(long id) throws NoSuchROIException {
        return this.roiComponent.getROI(id);
    }

    ROI createROI(ROIFigure figure) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.addROI(figure, this.getCurrentView());
    }

    ShapeList getShapeList() throws NoSuchROIException {
        return this.roiComponent.getShapeList(this.currentPlane);
    }

    void figureAttributeChanged(AttributeKey attribute, ROIFigure figure) {
        if (attribute.getKey().equals(AttributeKeys.TEXT.getKey())) {
            ROIShape shape = figure.getROIShape();
            AnnotationKeys.BASIC_TEXT.set(shape, (String)AttributeKeys.TEXT.get((Figure)figure));
        }
    }

    void setPixels(Pixels pixels) {
        this.pixels = pixels;
        this.pixelsDims = pixels.getPixelsDimensions();
        this.roiComponent.setMicronsPixelX(this.getPixelSizeX());
        this.roiComponent.setMicronsPixelY(this.getPixelSizeY());
        this.roiComponent.setMicronsPixelZ(this.getPixelSizeZ());
    }

    void saveROI() throws ParsingException {
        this.roiComponent.saveROI(IOUtil.writeFile(this.roiFileName));
    }

    void propagateShape(ROIShape shape, int timePoint, int zSection) throws ROICreationException, NoSuchROIException {
        this.roiComponent.propagateShape(shape.getID(), shape.getCoord3D(), shape.getCoord3D(), new Coord3D(zSection, timePoint));
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) throws ROICreationException, NoSuchROIException {
        this.roiComponent.deleteShape(shape.getID(), shape.getCoord3D(), new Coord3D(zSection, timePoint));
    }

    void showMeasurementsInMicrons(boolean inMicrons) {
        this.roiComponent.showMeasurementsInMicrons(inMicrons);
    }

    void setActiveChannels(Map activeChannels) {
        this.activeChannels = activeChannels;
    }

    void fireAnalyzeShape(ROIShape shape) {
        if (this.getState() == 4) {
            return;
        }
        ArrayList<ROIShape> l = new ArrayList<ROIShape>(1);
        l.add(shape);
        this.state = 4;
        ArrayList channels = new ArrayList(this.activeChannels.size());
        channels.addAll(this.activeChannels.keySet());
        this.currentLoader = new Analyser(this.component, this.pixels, channels, l);
        this.currentLoader.load();
    }

    void fireChannelMetadataLoading() {
        this.state = 2;
        this.currentLoader = new ChannelMetadataLoader(this.component, this.pixelsID);
        this.currentLoader.load();
    }

    void setChannelMetadata(List m) {
        this.metadata = new ChannelMetadata[m.size()];
        Iterator i = m.iterator();
        while (i.hasNext()) {
            ChannelMetadata cm;
            this.metadata[cm.getIndex()] = cm = (ChannelMetadata)i.next();
        }
    }

    ChannelMetadata[] getMetadata() {
        return this.metadata;
    }

    ChannelMetadata getMetadata(int index) {
        if (index < 0 || index >= this.metadata.length) {
            return null;
        }
        return this.metadata[index];
    }

    void setAnalysisResults(Map analysisResults) {
        this.analysisResults = analysisResults;
        this.state = 6;
    }

    Map getAnalysisResults() {
        return this.analysisResults;
    }

    Map getActiveChannels() {
        return this.activeChannels;
    }

    Color getActiveChannelColor(int index) {
        return (Color)this.activeChannels.get(index);
    }

    Collection<Figure> getSelectedFigures() {
        return this.drawingView.getSelectedFigures();
    }

    boolean isChannelActive(int index) {
        return this.activeChannels.get(index) != null;
    }
}

