/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.openmicroscopy.shoola.agents.measurement.actions.CreateFigureAction;
import org.openmicroscopy.shoola.agents.measurement.actions.LoadROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.actions.RefreshResultsTableAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ResultsWizardAction;
import org.openmicroscopy.shoola.agents.measurement.actions.SaveROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.SaveResultsAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ShowROIAssistant;
import org.openmicroscopy.shoola.agents.measurement.actions.UnitsAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;

class MeasurementViewerControl
implements ChangeListener,
DrawingListener,
FigureListener,
FigureSelectionListener,
PropertyChangeListener {
    static final Integer SAVE = new Integer(0);
    static final Integer LOAD = new Integer(1);
    static final Integer SAVE_RESULTS = new Integer(2);
    static final Integer REFRESH_RESULTS = new Integer(3);
    static final Integer RESULTS_WIZARD = new Integer(4);
    static final Integer ROI_ASSISTANT = new Integer(5);
    static final Integer IN_MICRONS = new Integer(6);
    static final Integer IN_PIXELS = new Integer(7);
    static final Integer CREATESINGLEFIGURE = new Integer(8);
    static final Integer CREATEMULTIPLEFIGURE = new Integer(9);
    private MeasurementViewer model;
    private MeasurementViewerUI view;
    private Map<Integer, MeasurementViewerAction> actionsMap;

    private void createActions() {
        this.actionsMap.put(SAVE, new SaveROIAction(this.model));
        this.actionsMap.put(LOAD, new LoadROIAction(this.model));
        this.actionsMap.put(SAVE_RESULTS, new SaveResultsAction(this.model));
        this.actionsMap.put(REFRESH_RESULTS, new RefreshResultsTableAction(this.model));
        this.actionsMap.put(RESULTS_WIZARD, new ResultsWizardAction(this.model));
        this.actionsMap.put(ROI_ASSISTANT, new ShowROIAssistant(this.model));
        this.actionsMap.put(IN_MICRONS, new UnitsAction(this.model, true));
        this.actionsMap.put(IN_PIXELS, new UnitsAction(this.model, false));
        this.actionsMap.put(CREATESINGLEFIGURE, new CreateFigureAction(this.model, true));
        this.actionsMap.put(CREATEMULTIPLEFIGURE, new CreateFigureAction(this.model, false));
    }

    MeasurementViewerControl() {
    }

    void initialize(MeasurementViewer model, MeasurementViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        model.addChangeListener(this);
        model.addPropertyChangeListener(this);
        this.actionsMap = new HashMap<Integer, MeasurementViewerAction>();
        this.createActions();
    }

    void attachListeners() {
        this.view.getLoadingWindow().addPropertyChangeListener("closed", this);
        this.view.getDrawing().addDrawingListener((DrawingListener)this);
        this.view.getDrawingView().addFigureSelectionListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MeasurementViewerControl.this.model.close(true);
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }
        });
    }

    MeasurementViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void showColorPicker(Color color) {
        if (color == null) {
            return;
        }
        ColourPicker colourPicker = new ColourPicker(this.view, color);
        colourPicker.addPropertyChangeListener("colour", this);
        UIUtilities.setLocationRelativeTo(this.view, (Component)colourPicker);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("colour".equals(name)) {
            this.view.setCellColor((Color)evt.getNewValue());
        } else if ("closed".equals(name)) {
            this.model.discard();
        }
    }

    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 4: {
                this.view.setStatus("Analysing Shape.");
                break;
            }
            case 2: {
                LoadingWindow w = this.view.getLoadingWindow();
                if (!w.isVisible()) {
                    UIUtilities.centerAndShow(w);
                }
                this.view.setStatus("Loading.");
                break;
            }
            case 6: {
                this.view.getLoadingWindow().setVisible(false);
                this.view.setStatus("Ready.");
                if (this.view.isVisible()) break;
                this.view.setOnScreen();
                break;
            }
            case 7: {
                LoadingWindow window = this.view.getLoadingWindow();
                window.setVisible(false);
                window.dispose();
                this.view.setVisible(false);
                this.view.dispose();
            }
        }
    }

    public void figureAdded(DrawingEvent e) {
        if (this.model.getState() != 6) {
            return;
        }
        Figure f = e.getFigure();
        if (!(f instanceof ROIFigure)) {
            return;
        }
        ROIFigure roiFigure = (ROIFigure)f;
        roiFigure.addFigureListener(this);
        this.view.addROI(roiFigure);
        if (this.view.inDataView() && roiFigure.getROIShape() != null) {
            this.model.analyseShape(roiFigure.getROIShape());
        }
    }

    public void figureRemoved(DrawingEvent e) {
        if (this.model.getState() != 6) {
            return;
        }
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            this.view.removeROI((ROIFigure)f);
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        ROIFigure figure;
        Collection figures = evt.getView().getSelectedFigures();
        if (figures == null) {
            return;
        }
        if (this.view.inDataView() && figures.size() == 1 && (figure = (ROIFigure)figures.iterator().next()).getROIShape() != null) {
            this.model.analyseShape(figure.getROIShape());
        }
        this.view.setSelectedFigures(figures);
    }

    public void figureAttributeChanged(FigureEvent e) {
        this.view.onAttributeChanged(e.getFigure());
        this.model.figureAttributeChanged(e.getAttribute(), (ROIFigure)e.getFigure());
    }

    public void figureChanged(FigureEvent e) {
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            ROIFigure roiFigure = (ROIFigure)f;
            roiFigure.calculateMeasurements();
            if (this.view.inDataView() && roiFigure.getROIShape() != null) {
                this.model.analyseShape(roiFigure.getROIShape());
            }
        }
    }

    public void areaInvalidated(DrawingEvent e) {
    }

    public void figureAdded(FigureEvent e) {
    }

    public void figureAreaInvalidated(FigureEvent e) {
    }

    public void figureRemoved(FigureEvent e) {
    }

    public void figureRequestRemove(FigureEvent e) {
    }

    public void analyseSelectedFigures() {
        ROIFigure figure;
        Collection figures = this.model.getSelectedFigures();
        if (figures.size() == 1 && (figure = (ROIFigure)figures.iterator().next()).getROIShape() != null) {
            this.model.analyseShape(figure.getROIShape());
        }
    }
}

