/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import ome.model.core.Pixels;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistant;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerComponent
extends AbstractComponent
implements MeasurementViewer {
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;

    private void postEvent(int index) {
        MeasurementToolLoaded response = new MeasurementToolLoaded(MeasurementViewerFactory.getRequest(this.model.getPixelsID()), (JComponent)((Object)this.model.getDrawingView()), index);
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        bus.post(response);
    }

    MeasurementViewerComponent(MeasurementViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MeasurementViewerControl();
        this.view = new MeasurementViewerUI(model.getImageName());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
    }

    MeasurementViewerModel getModel() {
        return this.model;
    }

    @Override
    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                this.model.fireChannelMetadataLoading();
                this.fireStateChange();
                break;
            }
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (!this.view.isVisible()) {
                    this.postEvent(0);
                }
                this.view.deIconify();
                this.view.setVisible(true);
            }
        }
    }

    @Override
    public JFrame getUI() {
        return this.view;
    }

    @Override
    public void discard() {
    }

    @Override
    public void cancel() {
        this.model.cancel();
        this.view.setStatus("");
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setROI(InputStream input) {
        if (this.model.getState() != 3) {
            return;
        }
        try {
            this.model.setROI(input);
        }
        catch (Exception e) {
            Registry reg = MeasurementAgent.getRegistry();
            if (e instanceof ParsingException) {
                reg.getLogger().error((Object)this, "Cannot parse the ROI for " + this.model.getImageID());
            }
            return;
        }
        this.view.rebuildManagerTable();
        this.view.updateDrawingArea();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setMagnifiedPlane(int defaultZ, int defaultT, double magnification) {
        int z = this.model.getDefaultZ();
        int t = this.model.getDefaultT();
        double f = this.model.getMagnification();
        if (z == defaultZ && t == defaultT) {
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        } else {
            this.model.setPlane(defaultZ, defaultT);
            Drawing drawing = this.model.getDrawing();
            drawing.removeDrawingListener((DrawingListener)this.controller);
            drawing.clear();
            ShapeList list = null;
            try {
                list = this.model.getShapeList();
            }
            catch (Exception e) {
                this.view.handleROIException(e, "Cannot retrieve the ROI");
            }
            this.view.setStatus("");
            if (list != null) {
                TreeMap<Long, ROIShape> map = list.getList();
                for (ROIShape shape : map.values()) {
                    if (shape == null) continue;
                    drawing.add((Figure)shape.getFigure());
                }
            }
            this.model.getDrawingView().setDrawing(drawing);
            drawing.addDrawingListener((DrawingListener)this.controller);
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        }
    }

    @Override
    public void setPixels(Pixels pixels) {
        if (this.model.getState() != 2) {
            return;
        }
        this.model.setPixels(pixels);
        double f = this.model.getMagnification();
        Dimension d = new Dimension((int)((double)this.model.getSizeX() * f), (int)((double)this.model.getSizeY() * f));
        UIUtilities.setDefaultSize((Component)((Object)this.model.getDrawingView()), d);
        this.model.getDrawingView().setSize(d);
        this.model.fireROILoading(null);
        this.fireStateChange();
    }

    @Override
    public void close(boolean post) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method shouldn't be invoked in the DISCARDED state:" + this.model.getState());
        }
        if (post) {
            this.postEvent(1);
        }
        this.view.setVisible(false);
    }

    @Override
    public void iconified(boolean b) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method shouldn't be invoked in the DISCARDED state:" + this.model.getState());
        }
        this.view.setVisible(b);
    }

    @Override
    public void loadROI() {
        int results;
        JFileChooser chooser = new JFileChooser();
        XMLFilter filter = new XMLFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if ((results = chooser.showOpenDialog(this.view.getParent())) != 0) {
            return;
        }
        this.model.fireROILoading(chooser.getSelectedFile().getAbsolutePath());
        this.fireStateChange();
        this.view.updateDrawingArea();
    }

    @Override
    public void saveROI() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.saveROI();
        }
        catch (ParsingException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        un.notifyInfo("Save ROI", "The Regions of Interests have been successfully saved. ");
    }

    @Override
    public void refreshResultsTable() {
        this.view.refreshResultsTable();
    }

    @Override
    public void rebuildManagerTable() {
        this.view.rebuildManagerTable();
    }

    @Override
    public void saveResultsTable() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        boolean saved = false;
        try {
            saved = this.view.saveResultsTable();
        }
        catch (Exception e) {
            reg.getLogger().error((Object)this, "Cannot save the results " + e.getMessage());
            un.notifyInfo("Save ROI results", "Cannot save the ROI results");
        }
        if (saved) {
            un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
        }
    }

    @Override
    public void figureAttributeChanged(AttributeKey key, ROIFigure figure) {
        this.model.figureAttributeChanged(key, figure);
    }

    @Override
    public void showResultsWizard() {
        this.view.showResultsWizard();
    }

    @Override
    public void showROIAssistant() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        if (this.view.inDataView()) {
            un.notifyInfo("ROI Assistant", "ROI Assistant cannot be used in graph pane or intensity view");
            return;
        }
        Collection<ROI> roiList = this.model.getSelectedROI();
        if (roiList.size() == 0) {
            un.notifyInfo("ROI Assistant", "Select a Figure to modify using the ROI Assistant.");
            return;
        }
        if (roiList.size() > 1) {
            un.notifyInfo("ROI Assistant", "The ROI Assistant canonly be used on one ROIat a time.");
            return;
        }
        ROI currentROI = roiList.iterator().next();
        ROIAssistant assistant = new ROIAssistant(this.model.getNumTimePoints(), this.model.getNumZSections(), this.model.getCurrentView(), currentROI, this.view);
        UIUtilities.setLocationRelativeToAndShow(this.view, assistant);
    }

    @Override
    public void showMeasurementsInMicrons(boolean inMicrons) {
        this.model.showMeasurementsInMicrons(inMicrons);
        this.view.updateDrawingArea();
    }

    @Override
    public void setActiveChannels(Map activeChannels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 7: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(activeChannels);
        if (this.view.inDataView()) {
            Collection collection = this.getSelectedFigures();
            if (collection.size() != 1) {
                return;
            }
            ROIFigure figure = (ROIFigure)collection.iterator().next();
            this.analyseShape(figure.getROIShape());
        }
    }

    @Override
    public void setActiveChannelsColor(Map channels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 7: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(channels);
        if (this.view.inDataView()) {
            Collection collection = this.getSelectedFigures();
            if (collection.size() != 1) {
                return;
            }
            ROIFigure figure = (ROIFigure)collection.iterator().next();
            this.analyseShape(figure.getROIShape());
        }
    }

    @Override
    public void setStatsShapes(Map result) {
        int state = this.model.getState();
        if (state != 4) {
            MeasurementAgent.getRegistry().getLogger().debug((Object)this, "This method can only be invoked in the ANALYSE_SHAPE state: " + state);
            return;
        }
        if (result == null || result.size() == 0) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Sets stats results", "No result to display.");
            return;
        }
        this.model.setAnalysisResults(result);
        this.view.displayAnalysisResults();
        this.fireStateChange();
    }

    @Override
    public void analyseShape(ROIShape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 7: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA or LOADING_ROI state: " + state);
            }
            case 4: {
                this.cancel();
            }
        }
        if (this.model.getActiveChannels().size() == 0) {
            return;
        }
        this.model.fireAnalyzeShape(shape);
        this.fireStateChange();
    }

    @Override
    public void setChannelMetadata(List list) {
        if (this.model.getState() != 2) {
            return;
        }
        this.model.setChannelMetadata(list);
        this.model.firePixelsLoading();
        this.fireStateChange();
    }

    @Override
    public Collection getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public void attachListeners(List<ROI> roiList) {
        for (int i = 0; i < roiList.size(); ++i) {
            ROI roi = roiList.get(i);
            for (ROIShape shape : roi.getShapes().values()) {
                shape.getFigure().addFigureListener(this.controller);
            }
        }
    }

    @Override
    public void createSingleFigure(boolean createSingleFig) {
        this.view.createSingleFigure(createSingleFig);
    }
}

