/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.AnnotationField;
import org.openmicroscopy.shoola.agents.measurement.util.MeasurementObject;
import org.openmicroscopy.shoola.agents.measurement.util.ResultsCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ResultsWizard;
import org.openmicroscopy.shoola.util.filter.file.CSVFilter;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class MeasurementResults
extends JPanel {
    private static final int COLUMNWIDTH = 64;
    private static final String NAME = "Results";
    private List<String> columnNames;
    private List<AnnotationField> fields;
    private List<AnnotationField> allFields;
    private JButton saveButton;
    private JButton refreshButton;
    private JButton resultsWizardButton;
    private ResultsTable results;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private ListSelectionListener listener;

    private void initComponents() {
        this.saveButton = new JButton(this.controller.getAction(MeasurementViewerControl.SAVE_RESULTS));
        this.resultsWizardButton = new JButton(this.controller.getAction(MeasurementViewerControl.RESULTS_WIZARD));
        this.refreshButton = new JButton(this.controller.getAction(MeasurementViewerControl.REFRESH_RESULTS));
        this.createAllFields();
        this.createDefaultFields();
        this.results = new ResultsTable();
        this.results.getTableHeader().setReorderingAllowed(false);
        MeasurementTableModel tm = new MeasurementTableModel(this.columnNames);
        this.results.setModel(tm);
        this.results.setSelectionMode(0);
        this.results.setRowSelectionAllowed(true);
        this.results.setColumnSelectionAllowed(false);
        this.listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int index = lsm.getMinSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    MeasurementTableModel m = (MeasurementTableModel)MeasurementResults.this.results.getModel();
                    long ROIID = (Long)m.getValueAt(index, 2);
                    int t = (Integer)m.getValueAt(index, 0) - 1;
                    int z = (Integer)m.getValueAt(index, 1) - 1;
                    MeasurementResults.this.view.selectFigure(ROIID, t, z);
                }
            }
        };
        this.results.getSelectionModel().addListSelectionListener(this.listener);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.results), "Center");
        JPanel panel = new JPanel();
        panel.add(this.resultsWizardButton);
        panel.add(this.refreshButton);
        panel.add(this.saveButton);
        this.add((Component)panel, "South");
    }

    private void createAllFields() {
        this.allFields = new ArrayList<AnnotationField>();
        this.allFields.add(new AnnotationField(AnnotationKeys.BASIC_TEXT, "Description", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.CENTREX, "Centre X", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.CENTREY, "Centre Y", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.AREA, "Area", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.PERIMETER, "Perimeter", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.LENGTH, "Length", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.WIDTH, "Width", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.HEIGHT, "Height", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ANGLE, "Angle", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.POINTARRAYX, "Points X Coord", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.POINTARRAYY, "Points Y Coord", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.STARTPOINTX, "Start Point X Coord", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.STARTPOINTY, "Start Point Y Coord", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ENDPOINTX, "End Point X Coord", false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ENDPOINTY, "End Point Y Coord", false));
    }

    private void createDefaultFields() {
        this.fields = new ArrayList<AnnotationField>();
        this.fields.add(new AnnotationField(AnnotationKeys.BASIC_TEXT, "Description", false));
        this.fields.add(new AnnotationField(AnnotationKeys.CENTREX, "Centre X", false));
        this.fields.add(new AnnotationField(AnnotationKeys.CENTREY, "Centre Y", false));
        this.fields.add(new AnnotationField(AnnotationKeys.AREA, "Area", false));
        this.fields.add(new AnnotationField(AnnotationKeys.PERIMETER, "Perimeter", false));
        this.fields.add(new AnnotationField(AnnotationKeys.LENGTH, "Length", false));
        this.fields.add(new AnnotationField(AnnotationKeys.ANGLE, "Angle", false));
        this.columnNames = new ArrayList<String>();
        this.columnNames.add("Time Point");
        this.columnNames.add("Z Section");
        this.columnNames.add("ROI ID");
        this.columnNames.add("Figure Type");
        for (int i = 0; i < this.fields.size(); ++i) {
            this.columnNames.add(this.fields.get(i).getName());
        }
    }

    private void writeColumns(BufferedWriter out) throws IOException {
        int n = this.results.getColumnCount() - 1;
        for (int i = 0; i < n + 1; ++i) {
            out.write(this.results.getColumnName(i));
            if (i >= n) continue;
            out.write(",");
        }
        out.newLine();
    }

    private void writeData(BufferedWriter out) throws IOException {
        MeasurementTableModel tm = (MeasurementTableModel)this.results.getModel();
        for (int i = 0; i < this.results.getRowCount(); ++i) {
            this.writeRow(out, tm.getRow(i));
        }
    }

    private void writeRow(BufferedWriter out, MeasurementObject row) throws IOException {
        int height = 1;
        int width = row.getSize();
        for (int i = 0; i < row.getSize(); ++i) {
            ArrayList list;
            Object element = row.getElement(i);
            if (!(element instanceof ArrayList) || (list = (ArrayList)element).size() <= height) continue;
            height = list.size();
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                out.write(this.writeElement(row.getElement(i), j));
                if (i >= width - 1) continue;
                out.write(",");
            }
            out.newLine();
        }
    }

    private String writeElement(Object element, int j) {
        if (element instanceof Double || element instanceof Integer || element instanceof Float || element instanceof String || element instanceof Boolean || element instanceof Long) {
            if (j == 0) {
                return this.convertElement(element);
            }
            return "";
        }
        if (element instanceof ArrayList) {
            ArrayList list = (ArrayList)element;
            if (j < list.size()) {
                return this.convertElement(list.get(j));
            }
            return "";
        }
        return "";
    }

    private String convertElement(Object element) {
        if (element instanceof Double) {
            return (Double)element + "";
        }
        if (element instanceof Boolean) {
            return ((Boolean)element).toString();
        }
        if (element instanceof Long) {
            return (Long)element + "";
        }
        if (element instanceof Integer) {
            return (Integer)element + "";
        }
        if (element instanceof Float) {
            return ((Float)element).floatValue() + "";
        }
        if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    MeasurementResults(MeasurementViewerControl controller, MeasurementViewerModel model, MeasurementViewerUI view) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void populate() {
        TreeMap map = this.model.getROI();
        Iterator i = map.keySet().iterator();
        MeasurementTableModel tm = new MeasurementTableModel(this.columnNames);
        while (i.hasNext()) {
            ROI roi = (ROI)map.get(i.next());
            TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
            Iterator<Coord3D> j = shapes.keySet().iterator();
            while (j.hasNext()) {
                ROIShape shape = shapes.get(j.next());
                ROIFigure figure = shape.getFigure();
                figure.calculateMeasurements();
                MeasurementObject row = new MeasurementObject();
                row.addElement(shape.getCoord3D().getTimePoint() + 1);
                row.addElement(shape.getCoord3D().getZSection() + 1);
                row.addElement(shape.getROI().getID());
                row.addElement(shape.getFigure().getType());
                for (int k = 0; k < this.fields.size(); ++k) {
                    AnnotationKey key = this.fields.get(k).getKey();
                    Object value = key.get(shape);
                    if (value instanceof ArrayList) {
                        ArrayList valueArray = (ArrayList)value;
                        ArrayList arrayList = new ArrayList(valueArray);
                        row.addElement(arrayList);
                        continue;
                    }
                    row.addElement(value);
                }
                tm.addRow(row);
            }
        }
        this.results.setModel(tm);
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        int columnWidth = 0;
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        MeasurementTableModel tm = (MeasurementTableModel)this.results.getModel();
        for (int i = 0; i < this.results.getColumnCount(); ++i) {
            TableColumn col = this.results.getColumnModel().getColumn(i);
            int w = metrics.stringWidth(tm.getColumnName(i));
            columnWidth = Math.max(w, 64);
            col.setMinWidth(columnWidth);
            col.setMaxWidth(columnWidth);
            col.setPreferredWidth(columnWidth);
            col.setResizable(false);
        }
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(3);
    }

    boolean saveResults() throws IOException {
        int response;
        int results;
        JFileChooser chooser = new JFileChooser();
        CSVFilter filter = new CSVFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if ((results = chooser.showSaveDialog(this.getParent())) != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        if (!file.getAbsolutePath().endsWith("csv")) {
            String fileName = file.getAbsolutePath() + "." + "csv";
            file = new File(fileName);
        }
        if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return false;
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        this.writeColumns(out);
        this.writeData(out);
        out.close();
        return true;
    }

    void refreshResults() {
        this.populate();
    }

    void showResultsWizard() {
        ResultsWizard resultsWizard = new ResultsWizard(this.fields, this.allFields);
        resultsWizard.pack();
        UIUtilities.setLocationRelativeToAndShow(this, resultsWizard);
        this.columnNames.clear();
        this.columnNames = new ArrayList<String>();
        this.columnNames.add("Time Point");
        this.columnNames.add("Z Section");
        this.columnNames.add("ROI ID");
        this.columnNames.add("Figure Type");
        for (int i = 0; i < this.fields.size(); ++i) {
            this.columnNames.add(this.fields.get(i).getName());
        }
        this.populate();
        this.results.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MeasurementTableModel
    extends AbstractTableModel {
        private List<String> columnNames;
        private List<MeasurementObject> values;

        MeasurementTableModel(List<String> columnNames) {
            if (columnNames == null) {
                throw new IllegalArgumentException("No column's names specified.");
            }
            this.columnNames = columnNames;
            this.values = new ArrayList<MeasurementObject>();
        }

        void addRow(MeasurementObject row) {
            this.values.add(row);
            this.fireTableStructureChanged();
        }

        MeasurementObject getRow(int index) {
            if (index < this.values.size()) {
                return this.values.get(index);
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > this.values.size()) {
                return null;
            }
            MeasurementObject rowData = this.values.get(row);
            return rowData.getElement(col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class ResultsTable
    extends JTable {
        ResultsTable() {
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return new ResultsCellRenderer();
        }
    }
}

