/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.ColourListRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.ChannelSelectionForm;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityModel;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityTable;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStats;
import org.openmicroscopy.shoola.util.filter.file.CSVFilter;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.BezierAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.EllipseAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineConnectionAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.PointAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.figures.RectAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class IntensityView
extends JPanel
implements ActionListener {
    private State state = State.READY;
    private static final String NAME = "Intensity View";
    private static final String SAVEACTION = "SAVEACTION";
    private static final String CHANNELSELECTION = "CHANNELSELECTION";
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private ChannelSelectionForm channelsSelectionForm;
    private Map ROIStats;
    private IntensityModel tableModel;
    private IntensityTable table;
    private JLabel minLabel;
    private JLabel maxLabel;
    private JLabel meanLabel;
    private JLabel stdDevLabel;
    private JLabel XCoordLabel;
    private JLabel YCoordLabel;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel XCentreLabel;
    private JLabel YCentreLabel;
    private JTextField minValue;
    private JTextField maxValue;
    private JTextField meanValue;
    private JTextField stdDevValue;
    private JTextField XCoordValue;
    private JTextField YCoordValue;
    private JTextField widthValue;
    private JTextField heightValue;
    private JTextField XCentreValue;
    private JTextField YCentreValue;
    private JComboBox channelSelection;
    private JButton saveButton;
    private Map<Integer, String> channelName = new TreeMap<Integer, String>();
    private Map<Integer, Color> channelColour = new TreeMap<Integer, Color>();
    private Map<Integer, Double> channelMin = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMax = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMean = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
    private Map<Integer, Map<PlanePoint2D, Double>> planePixels = new TreeMap<Integer, Map<PlanePoint2D, Double>>();
    Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private ROIShape shape;

    private void initComponents() {
        Double[][] data = new Double[1][1];
        this.tableModel = new IntensityModel(data);
        this.table = new IntensityTable(this.tableModel);
        this.minLabel = new JLabel("Min");
        this.maxLabel = new JLabel("Max");
        this.meanLabel = new JLabel("Mean");
        this.stdDevLabel = new JLabel("Std Dev.");
        this.XCoordLabel = new JLabel("X Coord");
        this.YCoordLabel = new JLabel("Y Coord");
        this.widthLabel = new JLabel("Width");
        this.heightLabel = new JLabel("Height");
        this.XCentreLabel = new JLabel("X Centre");
        this.YCentreLabel = new JLabel("Y Centre");
        this.minValue = new JTextField();
        this.maxValue = new JTextField();
        this.meanValue = new JTextField();
        this.stdDevValue = new JTextField();
        this.XCoordValue = new JTextField();
        this.YCoordValue = new JTextField();
        this.widthValue = new JTextField();
        this.heightValue = new JTextField();
        this.XCentreValue = new JTextField();
        this.YCentreValue = new JTextField();
        this.channelSelection = new JComboBox();
        this.channelSelection.addActionListener(this);
        this.channelSelection.setActionCommand(CHANNELSELECTION);
        this.saveButton = new JButton("Save Results");
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand(SAVEACTION);
        this.state = State.READY;
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel tPanel = this.tablePanel();
        tPanel.setAlignmentY(0.0f);
        this.add(tPanel);
        JPanel fPanel = this.fieldPanel();
        fPanel.setAlignmentY(0.0f);
        this.add(fPanel);
    }

    private JPanel tablePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBar(scrollPane.createVerticalScrollBar());
        scrollPane.setHorizontalScrollBar(scrollPane.createHorizontalScrollBar());
        panel.add(scrollPane);
        return panel;
    }

    private JPanel fieldPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        UIUtilities.setDefaultSize(this.channelSelection, new Dimension(150, 32));
        panel.add(this.channelSelection);
        panel.add(Box.createVerticalStrut(5));
        JPanel fields = this.createLabelText(this.minLabel, this.minValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.maxLabel, this.maxValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.meanLabel, this.meanValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.stdDevLabel, this.stdDevValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.XCoordLabel, this.XCoordValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.YCoordLabel, this.YCoordValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.widthLabel, this.widthValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.heightLabel, this.heightValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.XCentreLabel, this.XCentreValue);
        panel.add(fields);
        panel.add(Box.createVerticalStrut(5));
        fields = this.createLabelText(this.YCentreLabel, this.YCentreValue);
        panel.add(fields);
        panel.add(this.saveButton);
        Dimension minSize = new Dimension(5, 200);
        Dimension prefSize = new Dimension(5, 200);
        Dimension maxSize = new Dimension(100, Short.MAX_VALUE);
        panel.add(new Box.Filler(minSize, prefSize, maxSize));
        return panel;
    }

    IntensityView(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.INTENSITYVIEW);
    }

    public void displayAnalysisResults() {
        if (this.state == State.ANALYSING) {
            return;
        }
        this.state = State.ANALYSING;
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            return;
        }
        Iterator shapeIterator = this.ROIStats.keySet().iterator();
        this.channelName = new TreeMap<Integer, String>();
        this.nameMap = new HashMap<String, Integer>();
        this.channelColour = new TreeMap<Integer, Color>();
        this.channelMin = new TreeMap<Integer, Double>();
        this.channelMax = new TreeMap<Integer, Double>();
        this.channelMean = new TreeMap<Integer, Double>();
        this.channelStdDev = new TreeMap<Integer, Double>();
        this.planePixels = new TreeMap<Integer, Map<PlanePoint2D, Double>>();
        while (shapeIterator.hasNext()) {
            this.shape = (ROIShape)shapeIterator.next();
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                return;
            }
            Map shapeStats = (Map)this.ROIStats.get(this.shape);
            Iterator channelIterator = shapeStats.keySet().iterator();
            this.clearAllVariables();
            this.clearAllValues();
            while (channelIterator.hasNext()) {
                int channel = (Integer)channelIterator.next();
                ROIShapeStats stats = (ROIShapeStats)shapeStats.get(channel);
                this.channelMin.put(channel, stats.getMin());
                this.channelMax.put(channel, stats.getMax());
                this.channelMean.put(channel, stats.getMean());
                this.channelStdDev.put(channel, stats.getStandardDeviation());
                this.planePixels.put(channel, stats.getPixelsValue());
                this.channelName.put(channel, this.model.getMetadata(channel).getEmissionWavelength() + "");
                this.nameMap.put(this.channelName.get(channel), channel);
                this.channelColour.put(channel, (Color)this.model.getActiveChannels().get(channel));
            }
        }
        this.createComboBox();
        Object[] nameColour = (Object[])this.channelSelection.getSelectedItem();
        String string = (String)nameColour[1];
        int selectedChannel = this.nameMap.get(string);
        this.populateData(selectedChannel);
    }

    private void clearAllVariables() {
        this.channelName.clear();
        this.channelColour.clear();
        this.channelMin.clear();
        this.channelMax.clear();
        this.channelMean.clear();
        this.channelStdDev.clear();
        this.planePixels.clear();
        this.nameMap.clear();
    }

    private void clearAllValues() {
        this.channelSelection.removeAllItems();
    }

    private void createComboBox() {
        Object[][] channelCols = new Object[this.channelName.size()][2];
        Iterator<Integer> iterator = this.channelName.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            int channel = iterator.next();
            channelCols[i] = new Object[]{this.channelColour.get(channel), this.channelName.get(channel)};
            ++i;
        }
        this.channelSelection.setModel(new DefaultComboBoxModel((E[])channelCols));
        ColourListRenderer renderer = new ColourListRenderer();
        this.channelSelection.setRenderer(renderer);
        this.channelSelection.setSelectedIndex(0);
    }

    private void populateData(int channel) {
        this.populateTable(channel);
        this.populateFields(channel);
        this.state = State.READY;
    }

    private void populateTable(int channel) {
        Map<PlanePoint2D, Double> pixels = this.planePixels.get(channel);
        if (pixels == null) {
            return;
        }
        Iterator<PlanePoint2D> pixelIterator = pixels.keySet().iterator();
        if (!pixelIterator.hasNext()) {
            return;
        }
        PlanePoint2D point2 = pixelIterator.next();
        double minX = point2.getX();
        double maxX = point2.getX();
        double minY = point2.getY();
        double maxY = point2.getY();
        while (pixelIterator.hasNext()) {
            point2 = pixelIterator.next();
            minX = Math.min(minX, point2.getX());
            maxX = Math.max(maxX, point2.getX());
            minY = Math.min(minY, point2.getY());
            maxY = Math.max(maxY, point2.getY());
        }
        int sizeX = (int)(maxX - minX) + 1;
        int sizeY = (int)(maxY - minY + 1.0);
        Double[][] data = new Double[sizeX][sizeY];
        for (PlanePoint2D point2 : pixels.keySet()) {
            int x = (int)(point2.getX() - minX);
            int y = (int)(point2.getY() - minY);
            if (x >= sizeX || y >= sizeY) continue;
            Double value = pixels.containsKey(point2) ? pixels.get(point2) : new Double(0.0);
            data[x][y] = value;
        }
        this.tableModel = new IntensityModel(data);
        this.table.setModel(this.tableModel);
    }

    private void populateFields(int channel) {
        this.minValue.setText(this.FormatString(this.channelMin.get(channel)));
        this.maxValue.setText(this.FormatString(this.channelMax.get(channel)));
        this.meanValue.setText(this.FormatString(this.channelMean.get(channel)));
        this.stdDevValue.setText(this.FormatString(this.channelStdDev.get(channel)));
        ROIFigure fig = this.shape.getFigure();
        if (this.areaFigure(fig)) {
            this.setValuesForAreaFigure(fig);
        } else if (this.lineFigure(fig)) {
            this.setValuesForLineFigure(fig);
        } else if (this.pointFigure(fig)) {
            this.setValuesForPointFigure(fig);
        }
    }

    private void setValuesForAreaFigure(ROIFigure fig) {
        this.XCoordValue.setText(fig.getBounds().getX() + "");
        this.YCoordValue.setText(fig.getBounds().getY() + "");
        this.widthLabel.setText("Width");
        this.heightLabel.setText("Height");
        this.widthValue.setText(AnnotationKeys.WIDTH.get(this.shape) + "");
        this.heightValue.setText(AnnotationKeys.HEIGHT.get(this.shape) + "");
        this.XCentreValue.setText(this.FormatString(AnnotationKeys.CENTREX.get(this.shape)));
        this.YCentreValue.setText(this.FormatString(AnnotationKeys.CENTREY.get(this.shape)));
    }

    private void setValuesForLineFigure(ROIFigure fig) {
        this.XCoordValue.setText(AnnotationKeys.STARTPOINTX.get(this.shape) + "");
        this.YCoordValue.setText(AnnotationKeys.STARTPOINTY.get(this.shape) + "");
        this.widthLabel.setText("End X");
        this.heightLabel.setText("End Y");
        this.widthValue.setText(AnnotationKeys.ENDPOINTX.get(this.shape) + "");
        this.heightValue.setText(AnnotationKeys.ENDPOINTY.get(this.shape) + "");
        this.XCentreValue.setText(this.FormatString(AnnotationKeys.CENTREX.get(this.shape)));
        this.YCentreValue.setText(this.FormatString(AnnotationKeys.CENTREY.get(this.shape)));
    }

    private void setValuesForPointFigure(ROIFigure fig) {
        this.XCoordValue.setText(AnnotationKeys.CENTREX.get(this.shape) + "");
        this.YCoordValue.setText(AnnotationKeys.CENTREY.get(this.shape) + "");
        this.widthLabel.setText("Width");
        this.heightLabel.setText("Height");
        this.widthValue.setText("1");
        this.heightValue.setText("1");
        this.XCentreValue.setText(this.FormatString(AnnotationKeys.CENTREX.get(this.shape)));
        this.YCentreValue.setText(this.FormatString(AnnotationKeys.CENTREY.get(this.shape)));
    }

    private boolean areaFigure(ROIFigure fig) {
        BezierAnnotationFigure bFig;
        if (fig instanceof EllipseAnnotationFigure || fig instanceof RectAnnotationFigure) {
            return true;
        }
        return fig instanceof BezierAnnotationFigure && (bFig = (BezierAnnotationFigure)fig).isClosed();
    }

    private boolean lineFigure(ROIFigure fig) {
        BezierAnnotationFigure bFig;
        if (fig instanceof LineAnnotationFigure || fig instanceof LineConnectionAnnotationFigure) {
            return true;
        }
        return fig instanceof BezierAnnotationFigure && !(bFig = (BezierAnnotationFigure)fig).isClosed();
    }

    private boolean pointFigure(ROIFigure fig) {
        return fig instanceof PointAnnotationFigure;
    }

    private JPanel createLabelText(JLabel label, JTextField text) {
        UIUtilities.setDefaultSize(label, new Dimension(80, 26));
        UIUtilities.setDefaultSize(text, new Dimension(80, 26));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(text);
        return panel;
    }

    private String FormatString(double value) {
        try {
            return String.format("%.2f", value);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void saveResults() {
        int response;
        int results;
        JFileChooser chooser = new JFileChooser();
        CSVFilter filter = new CSVFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if ((results = chooser.showSaveDialog(this.getParent())) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getAbsolutePath().endsWith("csv")) {
            String fileName = file.getAbsolutePath() + "." + "csv";
            file = new File(fileName);
        }
        if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return;
        }
        this.channelsSelectionForm = new ChannelSelectionForm(this.channelName);
        UIUtilities.setLocationRelativeToAndShow(this, this.channelsSelectionForm);
        if (this.channelsSelectionForm.getState() != ChannelSelectionForm.State.ACCEPTED) {
            return;
        }
        List<Integer> userChannelSelection = this.channelsSelectionForm.getUserSelection();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < userChannelSelection.size(); ++i) {
                this.writeTitle(out, "Channel Number : " + this.channelName.get(i));
                this.writeData(out, i);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTitle(BufferedWriter out, String string) throws IOException {
        out.write(string);
        out.newLine();
    }

    private void writeData(BufferedWriter out, int channel) throws IOException {
        this.populateData(channel);
        this.addFields(out, channel);
        for (int y = 0; y < this.tableModel.getRowCount(); ++y) {
            Double value;
            for (int x = 0; x < this.tableModel.getColumnCount() - 1; ++x) {
                value = (Double)this.tableModel.getValueAt(y, x);
                if (value == null) {
                    value = new Double(0.0);
                }
                out.write(String.format("%.2f", value));
                out.write(",");
            }
            value = (Double)this.tableModel.getValueAt(y, this.tableModel.getColumnCount() - 1);
            if (value == null) {
                value = new Double(0.0);
            }
            out.write(String.format("%.2f", value));
            out.newLine();
        }
    }

    private void writeMinStat(BufferedWriter out, int channel) throws IOException {
        out.write("Minimum Intensity, ");
        out.write(this.channelMin.get(channel) + "");
    }

    private void writeMaxStat(BufferedWriter out, int channel) throws IOException {
        out.write("Maximum Intensity, ");
        out.write(this.channelMax.get(channel) + "");
    }

    private void writeMeanStat(BufferedWriter out, int channel) throws IOException {
        out.write("Mean Intensity, ");
        out.write(this.channelMean.get(channel) + "");
    }

    private void writeStdDevStat(BufferedWriter out, int channel) throws IOException {
        out.write("StdDev , ");
        out.write(this.channelStdDev.get(channel) + "");
    }

    private void writeXCoordStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.XCoordLabel.getText() + ",");
        out.write(this.XCoordValue.getText());
    }

    private void writeYCoordStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.YCoordLabel.getText() + ",");
        out.write(this.YCoordValue.getText());
    }

    private void writeWidthStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.widthLabel.getText() + ",");
        out.write(this.widthValue.getText());
    }

    private void writeHeightStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.heightLabel.getText() + ",");
        out.write(this.heightValue.getText());
    }

    private void writeXCentreStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.XCentreLabel.getText() + ",");
        out.write(this.XCentreValue.getText());
    }

    private void writeYCentreStat(BufferedWriter out, int channel) throws IOException {
        out.write(this.YCentreLabel.getText() + ",");
        out.write(this.YCentreValue.getText());
    }

    private void addFields(BufferedWriter out, int channel) throws IOException {
        this.writeMinStat(out, channel);
        out.newLine();
        this.writeMaxStat(out, channel);
        out.newLine();
        this.writeMeanStat(out, channel);
        out.newLine();
        this.writeStdDevStat(out, channel);
        out.newLine();
        this.writeXCoordStat(out, channel);
        out.newLine();
        this.writeYCoordStat(out, channel);
        out.newLine();
        this.writeWidthStat(out, channel);
        out.newLine();
        this.writeHeightStat(out, channel);
        out.newLine();
        this.writeXCentreStat(out, channel);
        out.newLine();
        this.writeYCentreStat(out, channel);
        out.newLine();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.state == State.ANALYSING) {
            return;
        }
        if (e.getActionCommand().equals(CHANNELSELECTION)) {
            JComboBox cb = (JComboBox)e.getSource();
            Object[] nameColour = (Object[])cb.getSelectedItem();
            String string = (String)nameColour[1];
            if (!this.nameMap.containsKey(string)) {
                return;
            }
            int channel = this.nameMap.get(string);
            if (channel != -1) {
                this.populateData(channel);
                this.populateFields(channel);
                this.repaint();
            }
        }
        if (e.getActionCommand().equals(SAVEACTION)) {
            this.saveResults();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ANALYSING,
        READY;

    }
}

