/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class IntensityTable
extends JTable {
    private static final int COLUMNWIDTH = 24;
    private static final Color GRIDCOLOUR = new Color(180, 213, 255);
    private int columnWidth;

    IntensityTable(TableModel model) {
        int w;
        this.setModel(model);
        this.setAutoResizeMode(0);
        int columnWidth = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            w = metrics.stringWidth(model.getColumnName(i));
            columnWidth = Math.max(w, 24);
        }
        w = metrics.stringWidth(model.getColumnName(0));
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            int width = columnWidth;
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setGridColor(GRIDCOLOUR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(true);
    }

    int getColumnWidth() {
        return this.columnWidth;
    }
}

