/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.figures.BezierAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramPlot;
import org.openmicroscopy.shoola.util.ui.graphutils.LinePlot;
import org.openmicroscopy.shoola.util.ui.graphutils.ScatterPlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphPane
extends JPanel {
    private static final String NAME = "Graph Pane";
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private Map ROIStats;

    private boolean lineProfileFigure(ROIShape shape) {
        BezierAnnotationFigure fig;
        ROIFigure f = shape.getFigure();
        if (f instanceof LineAnnotationFigure) {
            return true;
        }
        return f instanceof BezierAnnotationFigure && !(fig = (BezierAnnotationFigure)f).isClosed();
    }

    private double channelMinValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.keySet().iterator();
        double value = 0.0;
        while (i.hasNext()) {
            int channel = (Integer)i.next();
            value = Math.min(value, this.model.getMetadata(channel).getGlobalMin());
        }
        return value;
    }

    private double channelMaxValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.keySet().iterator();
        double value = 0.0;
        while (i.hasNext()) {
            int channel = (Integer)i.next();
            value = Math.max(value, this.model.getMetadata(channel).getGlobalMax());
        }
        return value;
    }

    private JPanel createLabelText(String str, String value) {
        JLabel label = new JLabel(str);
        JTextField text = new JTextField(value);
        UIUtilities.setDefaultSize(label, new Dimension(80, 26));
        UIUtilities.setDefaultSize(text, new Dimension(80, 26));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(text);
        return panel;
    }

    private void initComponents() {
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
    }

    GraphPane(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.GRAPHPANE);
    }

    void displayAnalysisResults() {
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null) {
            return;
        }
        Iterator shapeIterator = this.ROIStats.keySet().iterator();
        ArrayList<String> channelName = new ArrayList<String>();
        ArrayList<Color> channelColour = new ArrayList<Color>();
        ArrayList<double[]> channelData = new ArrayList<double[]>();
        ArrayList<double[][]> channelXYData = new ArrayList<double[][]>();
        JPanel histogramChart = null;
        JPanel lineProfileChart = null;
        Map activeChannels = this.model.getActiveChannels();
        while (shapeIterator.hasNext()) {
            ROIShape shape = (ROIShape)shapeIterator.next();
            if (shape.getFigure() instanceof MeasureTextFigure) {
                return;
            }
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)this.ROIStats.get(shape));
            channelName.clear();
            channelColour.clear();
            Map data = shapeStats.get((Object)AnalysisStatsWrapper.StatsType.PIXELDATA);
            Iterator channelIterator = data.keySet().iterator();
            while (channelIterator.hasNext()) {
                int channel = (Integer)channelIterator.next();
                if (!this.model.isChannelActive(channel)) continue;
                channelName.add(this.model.getMetadata(channel).getEmissionWavelength() + "");
                Color c = this.model.getActiveChannelColor(channel);
                channelColour.add(c);
                if (((double[])data.get(channel)).length == 0) {
                    return;
                }
                channelData.add((double[])data.get(channel));
                if (!this.lineProfileFigure(shape)) continue;
                double[] dataY = (double[])data.get(channel);
                double[][] dataXY = new double[2][dataY.length];
                if (dataY.length == 0) {
                    return;
                }
                for (int i = 0; i < dataY.length; ++i) {
                    dataXY[0][i] = i;
                    dataXY[1][i] = dataY[i];
                }
                channelXYData.add(dataXY);
            }
            if (this.lineProfileFigure(shape)) {
                lineProfileChart = this.drawLineplot("Line Profile", channelName, channelXYData, channelColour);
            }
            histogramChart = this.drawHistogram("Histogram", channelName, channelData, channelColour, 1001);
        }
        this.removeAll();
        if (histogramChart == null && lineProfileChart == null) {
            return;
        }
        if (lineProfileChart == null && histogramChart != null) {
            this.setLayout(new BorderLayout());
            this.add(histogramChart, "Center");
        }
        if (lineProfileChart != null && histogramChart != null) {
            this.setLayout(new BoxLayout(this, 1));
            this.add(lineProfileChart);
            this.add(histogramChart);
        }
    }

    JPanel drawScatterplot(String title, List<String> channelNames, List<double[][]> data, List<Color> channelColours) {
        ScatterPlot plot = new ScatterPlot(title, channelNames, data, channelColours);
        return plot.getChart();
    }

    JPanel drawLineplot(String title, List<String> channelNames, List<double[][]> data, List<Color> channelColours) {
        LinePlot plot = new LinePlot(title, channelNames, data, channelColours, this.channelMinValue(), this.channelMaxValue());
        return plot.getChart();
    }

    JPanel drawHistogram(String title, List<String> channelNames, List<double[]> data, List<Color> channelColours, int bins) {
        HistogramPlot plot = new HistogramPlot(title, channelNames, data, channelColours, bins, this.channelMinValue(), this.channelMaxValue());
        return plot.getChart();
    }
}

