/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelSelectionForm
extends JDialog
implements ActionListener {
    private static final String ACCEPTACTION = "ACCEPT";
    private static final String CANCELACTION = "CANCEL";
    private State state;
    Map<Integer, String> channelNames;
    private List<JCheckBox> checkBox;
    private JButton acceptButton;
    private JButton cancelButton;

    ChannelSelectionForm(Map<Integer, String> channelNames) {
        this.setSize(300, 200);
        this.setModal(true);
        this.setTitle("Select Channels to Save");
        this.channelNames = channelNames;
        this.state = State.INVALID;
        this.buildComponents();
        this.buildUI();
    }

    private void buildComponents() {
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setActionCommand(ACCEPTACTION);
        this.acceptButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCELACTION);
        this.cancelButton.addActionListener(this);
        this.checkBox = new ArrayList<JCheckBox>(this.channelNames.size());
        Iterator<Integer> nameIterator = this.channelNames.keySet().iterator();
        while (nameIterator.hasNext()) {
            JCheckBox cBox = new JCheckBox(this.channelNames.get(nameIterator.next()));
            this.checkBox.add(cBox);
        }
    }

    private void buildUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(new JLabel("Select Channels to Save"));
        for (int i = 0; i < this.checkBox.size(); ++i) {
            mainPanel.add(this.checkBox.get(i));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.acceptButton);
        panel.add(this.cancelButton);
        mainPanel.add(panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    public List<Integer> getUserSelection() {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        for (int i = 0; i < this.checkBox.size(); ++i) {
            int index;
            if (!this.checkBox.get(i).isSelected() || (index = this.getSelectedChannel(this.checkBox.get(i).getText())) == -1) continue;
            selection.add(index);
        }
        return selection;
    }

    private int getSelectedChannel(String comboBoxName) {
        for (int channel : this.channelNames.keySet()) {
            String channelString = this.channelNames.get(channel);
            if (!channelString.equals(comboBoxName)) continue;
            return channel;
        }
        return -1;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ACCEPTACTION)) {
            this.state = State.ACCEPTED;
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equals(CANCELACTION)) {
            this.state = State.CANCELLED;
            this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INVALID,
        ACCEPTED,
        CANCELLED;

    }
}

