/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DrawingView;

class BoundsConstrainer
implements Constrainer {
    private double width;
    private double height;

    BoundsConstrainer(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Width or height is <= 0");
        }
        this.width = width;
        this.height = height;
    }

    double getWidth() {
        return this.width;
    }

    double getHeight() {
        return this.height;
    }

    public Point2D.Double constrainPoint(Point2D.Double p) {
        double x = p.getX();
        double y = p.getY();
        if (x > this.width) {
            x = this.width;
        }
        if (y > this.height) {
            y = this.height;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        p.setLocation(x, y);
        return p;
    }

    public boolean isVisible() {
        return this.width > 1.0 && this.height > 1.0;
    }

    public void draw(Graphics2D g, DrawingView view) {
    }

    public String toString() {
        return super.toString() + "[" + this.width + "," + this.height + "]";
    }
}

