/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.RendererUtils;
import org.openmicroscopy.shoola.util.roi.model.util.FigureType;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ResultsCellRenderer
extends JComponent
implements TableCellRenderer {
    private String twoDecimalPlaces(Float value) {
        return UIUtilities.twoDecimalPlaces(value.doubleValue());
    }

    private String twoDecimalPlaces(Double value) {
        return UIUtilities.twoDecimalPlaces(value);
    }

    private JList createList(Object value) {
        ArrayList elementList = (ArrayList)value;
        JList list = new JList();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (Object element : elementList) {
            String v;
            if (element instanceof Float) {
                v = this.twoDecimalPlaces((Float)element);
                model.addElement(new String(v));
                continue;
            }
            if (!(element instanceof Double)) continue;
            v = this.twoDecimalPlaces((Double)element);
            model.addElement(new String(v));
        }
        list.setModel(model);
        return list;
    }

    public ResultsCellRenderer() {
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent thisComponent = new JLabel();
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof String || value instanceof Float || value instanceof FigureType) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            if (value instanceof Double) {
                label.setText(this.twoDecimalPlaces((Double)value));
            } else if (value instanceof Float) {
                label.setText(this.twoDecimalPlaces((Float)value));
            } else {
                label.setText(value + "");
            }
            thisComponent = label;
        } else if (value instanceof Color) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            label.setBackground((Color)value);
            thisComponent = label;
        } else if (value instanceof Boolean) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setSelected((Boolean)value);
            thisComponent = checkBox;
        } else if (value instanceof ArrayList) {
            thisComponent = this.createList(value);
        }
        if (!(value instanceof Color)) {
            RendererUtils.setRowColor(thisComponent, table.getSelectedRow(), row);
        }
        return thisComponent;
    }
}

