/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.undo.CompositeEdit;
import org.openmicroscopy.shoola.agents.measurement.util.MeasureCreationTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCreationTool
extends AbstractTool
implements MeasureCreationTool {
    private boolean resetToSelect = false;
    private Map<AttributeKey, Object> prototypeAttributes;
    private String name;
    private Figure prototype;
    protected Figure createdFigure;
    protected CompositeEdit creationEdit;

    public PointCreationTool(String prototypeClassName) {
        this(prototypeClassName, null, null);
    }

    public PointCreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes) {
        this(prototypeClassName, attributes, null);
    }

    public PointCreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes, String name) {
        try {
            this.prototype = (Figure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create Figure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.prototypeAttributes = attributes;
        this.name = name;
    }

    public PointCreationTool(Figure prototype) {
        this(prototype, null, null);
    }

    public PointCreationTool(Figure prototype, Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public PointCreationTool(Figure prototype, Map<AttributeKey, Object> attributes, String name) {
        this.prototype = prototype;
        this.prototypeAttributes = attributes;
        this.name = name;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    public void activate(DrawingEditor editor) {
        super.activate(editor);
    }

    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.getView().clearSelection();
        this.creationEdit = new CompositeEdit("Figur erstellen");
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
        this.createdFigure = this.createFigure();
        Point2D.Double p = this.constrainPoint(this.viewToDrawing(new Point((int)((double)evt.getX() - 11.0), (int)((double)evt.getY() - 11.0))));
        Point2D.Double p2 = this.constrainPoint(this.viewToDrawing(new Point((int)((double)evt.getX() + 11.0), (int)((double)evt.getY() + 11.0))));
        this.createdFigure.willChange();
        this.createdFigure.basicSetBounds(p, p2);
        this.createdFigure.changed();
        this.getDrawing().add(this.createdFigure);
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure != null) {
            Point2D.Double p = this.constrainPoint(new Point((int)((double)evt.getX() - 11.0), (int)((double)evt.getY() - 11.0)));
            Point2D.Double p2 = this.constrainPoint(new Point((int)((double)evt.getX() + 11.0), (int)((double)evt.getY() + 11.0)));
            this.createdFigure.willChange();
            this.createdFigure.basicSetBounds(p, p2);
            this.createdFigure.changed();
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure != null) {
            Rectangle2D.Double bounds = this.createdFigure.getBounds();
            if (bounds.width == 0.0 && bounds.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
            } else {
                Point2D.Double p = this.createdFigure.getStartPoint();
                Point2D.Double p1 = this.createdFigure.getEndPoint();
                double width = Math.abs(((Point2D)p).getX() - ((Point2D)p1).getX());
                double height = Math.abs(((Point2D)p).getY() - ((Point2D)p1).getY());
                if (width < 22.0) {
                    Point2D.Double centre = new Point2D.Double(this.createdFigure.getBounds().getCenterX(), this.createdFigure.getBounds().getCenterY());
                    Point2D.Double newP1 = new Point2D.Double(((Point2D)centre).getX() - 11.0, ((Point2D)centre).getY() - 11.0);
                    Point2D.Double newP2 = new Point2D.Double(((Point2D)centre).getX() + 11.0, ((Point2D)centre).getY() + 11.0);
                    this.createdFigure.willChange();
                    this.createdFigure.basicSetBounds(newP1, newP2);
                    this.createdFigure.changed();
                }
                this.getView().addToSelection(this.createdFigure);
            }
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
            this.creationFinished(this.createdFigure);
            this.createdFigure = null;
        }
    }

    protected Figure createFigure() {
        Figure f = (Figure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void creationFinished(Figure createdFigure) {
        if (this.resetToSelect) {
            this.fireToolDone();
        }
    }

    @Override
    public boolean isResetToSelect() {
        return this.resetToSelect;
    }

    @Override
    public void setResetToSelect(boolean create) {
        this.resetToSelect = create;
    }
}

