/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Bezier;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;
import org.openmicroscopy.shoola.agents.measurement.util.MeasureCreationTool;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;

public class MeasurementBezierTool
extends AbstractTool
implements MeasureCreationTool {
    private boolean resetToSelect = false;
    private Boolean finishWhenMouseReleased;
    protected Map<AttributeKey, Object> attributes;
    private MeasureBezierFigure prototype;
    protected MeasureBezierFigure createdFigure;
    private CompositeEdit creationEdit;
    private int nodeCountBeforeDrag;

    public MeasurementBezierTool(MeasureBezierFigure prototype) {
        this(prototype, null);
    }

    public MeasurementBezierTool(MeasureBezierFigure prototype, Map attributes) {
        this.prototype = prototype;
        this.attributes = attributes;
    }

    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().clearSelection();
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        if (this.createdFigure != null) {
            this.finishCreation(this.createdFigure);
            this.createdFigure = null;
            this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
        }
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        if (this.createdFigure == null) {
            this.finishWhenMouseReleased = null;
            this.creationEdit = new CompositeEdit("Figur erstellen");
            this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
            this.createdFigure = this.createFigure();
            this.createdFigure.addNode(new BezierPath.Node(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor))));
            this.getDrawing().add((Figure)this.createdFigure);
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        } else {
            if (evt.getClickCount() == 1) {
                this.addPointToFigure(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor)));
            }
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        }
    }

    protected MeasureBezierFigure createFigure() {
        MeasureBezierFigure f = (MeasureBezierFigure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo((Figure)f);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected ROIFigure getCreatedFigure() {
        return this.createdFigure;
    }

    protected ROIFigure getAddedFigure() {
        return this.createdFigure;
    }

    protected void addPointToFigure(Point2D.Double newPoint) {
        int pointCount = this.createdFigure.getNodeCount();
        this.createdFigure.willChange();
        if (pointCount < 2) {
            this.createdFigure.basicAddNode(new BezierPath.Node(newPoint));
        } else {
            Point2D.Double secondLastPoint;
            Point2D.Double endPoint = this.createdFigure.getEndPoint();
            Point2D.Double double_ = secondLastPoint = pointCount <= 1 ? endPoint : this.createdFigure.getPoint(pointCount - 2, 0);
            if (!newPoint.equals(endPoint)) {
                if (pointCount > 1 && Geom.lineContainsPoint((double)newPoint.x, (double)newPoint.y, (double)secondLastPoint.x, (double)secondLastPoint.y, (double)endPoint.x, (double)endPoint.y, (double)((double)0.9f / this.getView().getScaleFactor()))) {
                    this.createdFigure.basicSetPoint(pointCount - 1, 0, newPoint);
                } else {
                    this.createdFigure.basicAddNode(new BezierPath.Node(newPoint));
                }
            }
        }
        this.createdFigure.changed();
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.createdFigure != null) {
            switch (evt.getClickCount()) {
                case 1: {
                    if (this.createdFigure.getNodeCount() <= 2) break;
                    Rectangle r = new Rectangle(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                    r.grow(2, 2);
                    if (!r.contains(evt.getX(), evt.getY())) break;
                    this.createdFigure.setClosed(true);
                    this.finishCreation(this.createdFigure);
                    this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
                    this.createdFigure = null;
                    if (!this.resetToSelect) break;
                    this.fireToolDone();
                    break;
                }
                case 2: {
                    this.finishWhenMouseReleased = null;
                    this.finishCreation(this.createdFigure);
                    this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
                    this.createdFigure = null;
                    if (!this.resetToSelect) break;
                    this.fireToolDone();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.finishWhenMouseReleased == Boolean.TRUE) {
            if (this.createdFigure.getNodeCount() > 2) {
                BezierPath fittedPath = Bezier.fitBezierCurve((BezierPath)this.createdFigure.getBezierPath(), (double)1.0);
                this.createdFigure.willChange();
                this.createdFigure.basicSetBezierPath(fittedPath);
                this.createdFigure.changed();
                this.finishCreation(this.createdFigure);
                this.createdFigure = null;
                this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
                this.finishWhenMouseReleased = null;
                if (this.resetToSelect) {
                    this.fireToolDone();
                }
                return;
            }
        } else if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.FALSE;
        }
        if (this.createdFigure.getNodeCount() > this.nodeCountBeforeDrag + 1) {
            this.createdFigure.willChange();
            BezierPath fittedPath = new BezierPath();
            int n = this.createdFigure.getNodeCount();
            for (int i = this.nodeCountBeforeDrag; i < n; ++i) {
                fittedPath.add((Object)this.createdFigure.getNode(this.nodeCountBeforeDrag));
                this.createdFigure.measureBasicRemoveNode(this.nodeCountBeforeDrag);
            }
            fittedPath = Bezier.fitBezierCurve((BezierPath)fittedPath, (double)1.0);
            for (BezierPath.Node node : fittedPath) {
                this.createdFigure.basicAddNode(node);
            }
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
            this.createdFigure.changed();
        }
    }

    protected void finishCreation(MeasureBezierFigure createdFigure) {
        this.getView().addToSelection((Figure)createdFigure);
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure != null) {
            if (this.finishWhenMouseReleased == null) {
                this.finishWhenMouseReleased = Boolean.TRUE;
            }
            int x = evt.getX();
            int y = evt.getY();
            this.addPointToFigure(this.getView().viewToDrawing(new Point(x, y)));
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public boolean isResetToSelect() {
        return this.resetToSelect;
    }

    public void setResetToSelect(boolean create) {
        this.resetToSelect = create;
    }
}

