/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.agents.measurement.util.ColourIcon;

public class ColourListRenderer
extends JLabel
implements ListCellRenderer {
    private static ColourIcon icon = new ColourIcon(15, 15);
    private Border lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
    private Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);

    public ColourListRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        Object[] array = (Object[])value;
        Color c = (Color)array[0];
        if (c != null) {
            icon.setColour(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        }
        this.setIcon(icon);
        this.setVerticalAlignment(0);
        this.setIconTextGap(40);
        this.setText((String)array[1]);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(this.lineBorder);
        } else {
            this.setBorder(this.emptyBorder);
        }
        return this;
    }
}

