/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStats;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisStatsWrapper {
    public static Map<StatsType, Map> convertStats(Map shapeStats) {
        if (shapeStats == null || shapeStats.size() == 0) {
            return null;
        }
        TreeMap<Integer, Double> channelMin = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelMax = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelMean = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
        TreeMap<Integer, double[]> channelData = new TreeMap<Integer, double[]>();
        Iterator channelIterator = shapeStats.keySet().iterator();
        while (channelIterator.hasNext()) {
            int channel = (Integer)channelIterator.next();
            ROIShapeStats stats = (ROIShapeStats)shapeStats.get(channel);
            channelMin.put(channel, stats.getMin());
            channelMax.put(channel, stats.getMax());
            channelMean.put(channel, stats.getMean());
            channelStdDev.put(channel, stats.getStandardDeviation());
            Map<PlanePoint2D, Double> pixels = stats.getPixelsValue();
            Iterator<Double> pixelIterator = pixels.values().iterator();
            double[] pixelData = new double[pixels.size()];
            int cnt = 0;
            while (pixelIterator.hasNext()) {
                double dataPt;
                pixelData[cnt] = dataPt = pixelIterator.next().doubleValue();
                ++cnt;
            }
            channelData.put(channel, pixelData);
        }
        HashMap<StatsType, Map> statsMap = new HashMap<StatsType, Map>(StatsType.values().length);
        statsMap.put(StatsType.MIN, channelMin);
        statsMap.put(StatsType.MAX, channelMax);
        statsMap.put(StatsType.MEAN, channelMean);
        statsMap.put(StatsType.STDDEV, channelStdDev);
        statsMap.put(StatsType.PIXELDATA, channelData);
        return statsMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatsType {
        MIN,
        MAX,
        MEAN,
        STDDEV,
        PIXELDATA;

    }
}

