/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import org.openmicroscopy.shoola.agents.events.iviewer.ChannelSelection;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurePlane;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;

public class MeasurementAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    private void handleMeasurementToolEvent(MeasurementTool evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID(), evt.getImageID(), evt.getName(), evt.getRequesterBounds(), evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification(), evt.getActiveChannels());
        if (viewer != null) {
            MeasurementViewerFactory.addRequest(evt);
            viewer.activate();
        }
    }

    private void handleMeasurePlaneEvent(MeasurePlane evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            viewer.setMagnifiedPlane(evt.getDefaultZ(), evt.getDefaultT(), evt.getMagnification());
        }
    }

    private void handleViewerStateEvent(ViewerState evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 0: {
                    viewer.close(false);
                    break;
                }
                case 1: {
                    viewer.iconified(false);
                    break;
                }
                case 2: {
                    viewer.iconified(true);
                }
            }
        }
    }

    private void handleChannelSelectionEvent(ChannelSelection evt) {
        MeasurementViewer viewer = MeasurementViewerFactory.getViewer(evt.getPixelsID());
        if (viewer != null) {
            switch (evt.getIndex()) {
                case 1: {
                    viewer.setActiveChannels(evt.getChannels());
                    break;
                }
                case 0: {
                    viewer.setActiveChannelsColor(evt.getChannels());
                }
            }
        }
    }

    public static Registry getRegistry() {
        return registry;
    }

    public void activate() {
    }

    public boolean canTerminate() {
        return true;
    }

    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = ctx.getEventBus();
        bus.register((AgentEventListener)this, MeasurementTool.class);
        bus.register((AgentEventListener)this, MeasurePlane.class);
        bus.register((AgentEventListener)this, ViewerState.class);
        bus.register((AgentEventListener)this, ChannelSelection.class);
    }

    public void terminate() {
    }

    public void eventFired(AgentEvent e) {
        if (e instanceof MeasurementTool) {
            this.handleMeasurementToolEvent((MeasurementTool)e);
        } else if (e instanceof MeasurePlane) {
            this.handleMeasurePlaneEvent((MeasurePlane)e);
        } else if (e instanceof ViewerState) {
            this.handleViewerStateEvent((ViewerState)e);
        } else if (e instanceof ChannelSelection) {
            this.handleChannelSelectionEvent((ChannelSelection)e);
        }
    }
}

