/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    private static final String SAVE_ON_CLOSE = "Save settings on close";
    private static final String SAVE_ON_CLOSE_DESCRIPTION = "Save the rendering settings before closing the viewer.";
    private ImViewerControl controller;
    private ImViewerModel model;
    private JToolBar bar;
    private JCheckBox saveOnClose;

    private void createControlsBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setRollover(true);
        this.bar.setBorder(null);
        JButton button = new JButton(this.controller.getAction(ImViewerControl.RENDERER));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.LENS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.ZOOM_IN));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.ZOOM_OUT));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.ZOOM_FIT));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.MEASUREMENT_TOOL));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.IMAGE_DETAILS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.DOWNLOAD));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        this.bar.add(this.saveOnClose);
    }

    private void initComponents() {
        this.saveOnClose = new JCheckBox(SAVE_ON_CLOSE);
        this.saveOnClose.setToolTipText(SAVE_ON_CLOSE_DESCRIPTION);
        this.saveOnClose.setSelected(true);
        this.createControlsBar();
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0));
        this.add(this.bar);
    }

    ToolBar(ImViewerControl controller, ImViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
    }

    void buildComponent() {
        this.buildGUI();
    }

    boolean saveSettingsOnClose() {
        return this.saveOnClose.isSelected();
    }
}

