/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelColorMenuItem;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.imviewer.view.ToolBar;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.ColorCheckBoxMenuItem;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;

class ImViewerUI
extends TopWindow {
    private static final Color INDIGO = new Color(75, 0, 130);
    private static final Color VIOLET = new Color(238, 130, 238);
    private static Map<Color, String> colors = new LinkedHashMap<Color, String>();
    private static Map<Color, String> backgrounds;
    private ImViewerControl controller;
    private ImViewerModel model;
    private StatusBar statusBar;
    private LensComponent lens;
    private ToolBar toolBar;
    private ControlPane controlPane;
    private ButtonGroup ratingGroup;
    private ButtonGroup zoomingGroup;
    private ButtonGroup colorModelGroup;
    private LoadingWindow loadingWindow = new LoadingWindow(this);
    private JTabbedPane tabs;

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createZoomMenu());
        this.createRatingMenu();
        TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
        menuBar.add(tb.getWindowsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenuItem createBackgroundColorSubMenu() {
        JMenu menu = new JMenu("Background color");
        ButtonGroup group = new ButtonGroup();
        for (Color c : backgrounds.keySet()) {
            ColorCheckBoxMenuItem item = new ColorCheckBoxMenuItem(c);
            item.setText(backgrounds.get(c));
            item.setSelected(c.equals(ImagePaintingFactory.DEFAULT_BACKGROUND));
            group.add(item);
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorCheckBoxMenuItem src = (ColorCheckBoxMenuItem)e.getSource();
                    if (src.isSelected()) {
                        ImViewerUI.this.model.getBrowser().setBackgroundColor(src.getColor());
                    }
                }
            });
        }
        return menu;
    }

    private JMenuItem createScaleBarColorSubMenu() {
        JMenu menu = new JMenu("Scale bar color");
        ButtonGroup group = new ButtonGroup();
        for (Color c : colors.keySet()) {
            ColorCheckBoxMenuItem item = new ColorCheckBoxMenuItem(c);
            item.setText(colors.get(c));
            item.setSelected(c.equals(ImagePaintingFactory.UNIT_BAR_COLOR));
            group.add(item);
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorCheckBoxMenuItem source = (ColorCheckBoxMenuItem)e.getSource();
                    if (source.isSelected()) {
                        ImViewerUI.this.model.getBrowser().setUnitBarColor(source.getColor());
                    }
                }
            });
        }
        return menu;
    }

    private JMenu createScaleBarLenghtSubMenu() {
        JMenu menu = new JMenu("Scale bar length (in  \u00b5m)");
        ButtonGroup group = new ButtonGroup();
        UnitBarSizeAction a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_ONE);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
        item.setSelected(a.isDefaultIndex());
        group.add(item);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TWO);
        item = new JCheckBoxMenuItem(a);
        item.setSelected(a.isDefaultIndex());
        group.add(item);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_FIVE);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_FIVE));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TEN);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_TEN));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TWENTY);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_TWENTY));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_FIFTY);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_FIFTY));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_HUNDRED);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_HUNDRED));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_CUSTOM);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_CUSTOM));
        group.add(item);
        item.setSelected(a.isDefaultIndex());
        menu.add(item);
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setSelected(this.model.isUnitBar());
        item.setAction(this.controller.getAction(ImViewerControl.UNIT_BAR));
        menu.add(item);
        menu.add(this.createScaleBarLenghtSubMenu());
        menu.add(this.createScaleBarColorSubMenu());
        menu.add(new JSeparator(0));
        menu.add(this.createBackgroundColorSubMenu());
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic(72);
        TaskBar bar = ImViewerAgent.getRegistry().getTaskBar();
        JMenuItem item = bar.getCopyMenuItem(100);
        if (item != null) {
            menu.add(item);
        }
        return menu;
    }

    private JMenu createControlsMenu() {
        JMenu menu = new JMenu("Controls");
        menu.setMnemonic(67);
        ViewerAction action = this.controller.getAction(ImViewerControl.RENDERER);
        JMenuItem item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.MOVIE);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.LENS);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        this.colorModelGroup = new ButtonGroup();
        action = this.controller.getAction(ImViewerControl.GREY_SCALE_MODEL);
        item = new JCheckBoxMenuItem();
        String cm = this.model.getColorModel();
        item.setSelected(cm.equals("greyscale"));
        item.setAction(action);
        this.colorModelGroup.add(item);
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.RGB_MODEL);
        item = new JCheckBoxMenuItem();
        item.setAction(action);
        item.setSelected(cm.equals("rgb") || cm.equals("hsb"));
        this.colorModelGroup.add(item);
        menu.add(item);
        menu.add(new JSeparator());
        action = this.controller.getAction(ImViewerControl.SAVE);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.DOWNLOAD);
        item = new JMenuItem(action);
        item.setText(action.getName());
        return menu;
    }

    private JMenu createZoomMenu() {
        JMenu menu = new JMenu("Zoom");
        menu.setMnemonic(90);
        this.zoomingGroup = new ButtonGroup();
        ViewerAction action = this.controller.getAction(ImViewerControl.ZOOM_25);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_50);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_75);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_100);
        item = new JCheckBoxMenuItem();
        item.setAction(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_125);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_150);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_175);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_200);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_225);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_250);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_275);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_300);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_FIT_TO_WINDOW);
        item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.zoomingGroup.add(item);
        this.setZoomFactor(3);
        return menu;
    }

    private JMenu createRatingMenu() {
        JMenu menu = new JMenu("Rating");
        menu.setMnemonic(82);
        this.ratingGroup = new ButtonGroup();
        ViewerAction action = this.controller.getAction(ImViewerControl.RATING_ONE);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setSelected(this.model.getRatingLevel() == 3);
        item.setText(action.getName());
        item.setAction(action);
        menu.add(item);
        this.ratingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.RATING_TWO);
        item = new JCheckBoxMenuItem();
        item.setSelected(this.model.getRatingLevel() == 4);
        item.setAction(action);
        item.setText(action.getName());
        menu.add(item);
        this.ratingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.RATING_THREE);
        item = new JCheckBoxMenuItem();
        item.setSelected(this.model.getRatingLevel() == 5);
        item.setAction(action);
        item.setText(action.getName());
        menu.add(item);
        this.ratingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.RATING_FOUR);
        item = new JCheckBoxMenuItem();
        item.setSelected(this.model.getRatingLevel() == 6);
        item.setAction(action);
        item.setText(action.getName());
        menu.add(item);
        this.ratingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.RATING_FIVE);
        item = new JCheckBoxMenuItem();
        item.setSelected(this.model.getRatingLevel() == 7);
        item.setAction(action);
        item.setText(action.getName());
        menu.add(item);
        this.ratingGroup.add(item);
        return menu;
    }

    private void buildGUI() {
        Browser browser = this.model.getBrowser();
        browser.setComponentsSize(this.model.getMaxX(), this.model.getMaxY());
        this.tabs = new JTabbedPane(1, 0);
        this.tabs.setAlignmentX(0.0f);
        JPanel p = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0}, {-1.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])tl));
        p.add((Component)this.controlPane, "0, 0");
        p.add((Component)browser.getUI(), "1, 0");
        p.add((Component)this.controlPane.getTimeSliderPane(0), "1, 1");
        this.tabs.insertTab(browser.getTitle(), browser.getIcon(), p, "", 0);
        browser.layoutAnnotator(this.controlPane.buildAnnotatorComponent(), this.controlPane.getTimeSliderPane(1));
        this.tabs.insertTab(browser.getAnnotatorTitle(), browser.getAnnotatorIcon(), browser.getAnnotator(), "", 1);
        p = new JPanel();
        p.setLayout((LayoutManager)new TableLayout((double[][])tl));
        p.add((Component)this.controlPane.buildGridComponent(), "0, 0");
        p.add((Component)browser.getGridView(), "1, 0");
        p.add((Component)this.controlPane.getTimeSliderPane(2), "1, 1");
        this.tabs.insertTab(browser.getGridViewTitle(), browser.getGridViewIcon(), p, "", 2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.tabs, "Center");
        container.add((Component)this.statusBar, "South");
        this.tabs.addChangeListener(this.controller);
        this.tabs.setEnabledAt(2, this.model.getMaxC() != 1);
    }

    ImViewerUI(String title) {
        super(title);
    }

    void initialize(ImViewerControl controller, ImViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.toolBar = new ToolBar(controller, model);
        this.controlPane = new ControlPane(controller, model, this);
        this.statusBar = new StatusBar();
        this.addComponentListener(controller);
    }

    void buildComponents() {
        this.setJMenuBar(this.createMenuBar());
        this.toolBar.buildComponent();
        this.controlPane.buildComponent();
        this.buildGUI();
    }

    void setZoomFactor(int zoomIndex) {
        Enumeration<AbstractButton> e = this.zoomingGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem b = (JCheckBoxMenuItem)e.nextElement();
            Action a = b.getAction();
            if (!(a instanceof ZoomAction)) continue;
            b.removeActionListener(a);
            b.setSelected(((ZoomAction)a).getIndex() == zoomIndex);
            b.setAction(a);
        }
    }

    void setRatingFactor(ViewerAction action) {
        this.controlPane.setRatingFactor(action);
        Enumeration<AbstractButton> e = this.ratingGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.getAction().equals(action)) continue;
            b.removeActionListener(action);
            b.setAction(action);
        }
    }

    void setColorModel(int key) {
        this.controlPane.setColorModel();
        Enumeration<AbstractButton> e = this.colorModelGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            Action a = b.getAction();
            if (!(a instanceof ColorModelAction)) continue;
            b.removeActionListener(a);
            b.setSelected(((ColorModelAction)a).getIndex() == key);
            b.setAction(a);
        }
    }

    void setZSection(int z) {
        this.controlPane.setZSection(z);
    }

    void setTimepoint(int t) {
        this.controlPane.setTimepoint(t);
    }

    LoadingWindow getLoadingWindow() {
        return this.loadingWindow;
    }

    void onStateChange(boolean b) {
        this.controlPane.onStateChange(b);
    }

    void setStatus(String description) {
        this.statusBar.setStatus(description);
    }

    void setChannelsSelection() {
        this.controlPane.setChannelsSelection();
    }

    void setChannelColor(int index, Color c) {
        this.controlPane.setChannelColor(index, c);
    }

    void resetDefaults() {
        this.controlPane.resetDefaults();
    }

    void setLensPlaneImage() {
        if (this.lens == null) {
            return;
        }
        switch (this.model.getTabbedIndex()) {
            case 0: {
                this.lens.setPlaneImage(this.model.getOriginalImage());
                break;
            }
            case 2: {
                this.lens.setPlaneImage(this.model.getGridImage());
                break;
            }
            case 1: {
                this.lens.setPlaneImage(this.model.getAnnotateImage());
            }
        }
    }

    BufferedImage createZoomedLensImage(BufferedImage image) {
        if (this.lens == null) {
            return null;
        }
        return this.lens.createZoomedImage(image);
    }

    boolean isLensVisible() {
        if (this.lens != null) {
            return this.lens.isVisible();
        }
        return false;
    }

    boolean hasLensImage() {
        return this.lens != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setLensVisible(boolean b, int historyIndex) {
        BufferedImage img;
        boolean firstTime = false;
        if (this.lens == null) {
            if (!b) return;
            firstTime = true;
            this.lens = new LensComponent(this);
            this.lens.setXYPixelMicron(this.model.getPixelsSizeX(), this.model.getPixelsSizeY());
            this.lens.addPropertyChangeListener(LensComponent.LENS_LOCATION_PROPERTY, this.controller);
        } else {
            Browser browser = this.model.getBrowser();
            LensUI c = this.lens.getLensUI();
            browser.removeComponent(c, 0);
            browser.removeComponent(c, 2);
            browser.removeComponent(c, 1);
        }
        if (!b) {
            this.lens.setVisible(b);
            this.repaint();
            return;
        }
        int maxX = this.model.getMaxX();
        int maxY = this.model.getMaxY();
        float f = 1.0f;
        int index = this.model.getTabbedIndex();
        switch (index) {
            default: {
                f = (float)this.model.getZoomFactor();
                img = this.model.getOriginalImage();
                break;
            }
            case 2: {
                img = this.model.getGridImage();
                break;
            }
            case 1: {
                img = this.model.getOriginalImage();
                f = (float)this.model.getBrowser().getRatio();
            }
        }
        int width = this.lens.getLensUI().getWidth();
        int height = this.lens.getLensUI().getHeight();
        Point p = this.lens.getLensLocation();
        int lensX = p.x;
        int lensY = p.y;
        if (maxX < width || maxY < height) {
            return;
        }
        if (firstTime) {
            int diffX = maxX - width;
            int diffY = maxY - height;
            lensX = diffX / 2;
            lensY = diffY / 2;
            if (lensX + width > maxX) {
                lensX = diffX;
            }
            if (lensY + height > maxY) {
                lensY = diffY;
            }
        } else {
            switch (historyIndex) {
                case 2: {
                    if (historyIndex == index) break;
                    Point point = this.model.getBrowser().isOnImageInGrid(this.lens.getLensScaledBounds());
                    if (point == null) {
                        int diffX = maxX - width;
                        int diffY = maxY - height;
                        lensX = diffX / 2;
                        lensY = diffY / 2;
                        if (lensX + width > maxX) {
                            lensX = diffX;
                        }
                        if (lensY + height <= maxY) break;
                        lensY = diffY;
                        break;
                    }
                    double r = this.model.getBrowser().getRatio();
                    lensX = (int)((double)point.x / r);
                    lensY = (int)((double)point.y / r);
                    break;
                }
                case 0: 
                case 1: {
                    if (index != 2) break;
                    double r = this.model.getBrowser().getRatio();
                    lensX = (int)((double)lensX * r);
                    lensY = (int)((double)lensY * r);
                }
            }
        }
        this.lens.resetLens(img, f, lensX, lensY);
        this.model.getBrowser().addComponent(this.lens.getLensUI(), index);
        this.scrollLens();
        UIUtilities.setLocationRelativeTo(this, this.lens.getZoomWindowUI());
        this.lens.setVisible(b);
        this.repaint();
    }

    BufferedImage getZoomedLensImage() {
        if (this.lens == null) {
            return null;
        }
        return this.lens.getZoomedImage();
    }

    void setImageZoomFactor(float factor) {
        if (this.lens == null) {
            return;
        }
        this.lens.setImageZoomFactor(factor);
    }

    void onIconified() {
        if (this.lens == null) {
            return;
        }
        this.lens.setVisible(false);
        this.repaint();
    }

    void showMenu(int menuID, Component source, Point location) {
        if (menuID != 0) {
            return;
        }
        ChannelMetadata[] data = this.model.getChannelData();
        JPopupMenu menu = new JPopupMenu();
        for (int j = 0; j < data.length; ++j) {
            ChannelMetadata d = data[j];
            ChannelColorMenuItem item = new ChannelColorMenuItem("Wavelength " + d.getEmissionWavelength(), this.model.getChannelColor(j), j);
            menu.add(item);
            item.addPropertyChangeListener(this.controller);
        }
        menu.show(source, location.x, location.y);
    }

    void scrollToNode(Rectangle bounds) {
        if (this.lens == null) {
            return;
        }
        if (!this.lens.isVisible()) {
            return;
        }
        this.model.getBrowser().scrollTo(bounds, true);
    }

    void scrollLens() {
        if (this.lens == null) {
            return;
        }
        this.model.getBrowser().scrollTo(this.lens.getLensScaledBounds(), false);
    }

    void setSelectedPane(int index) {
        int oldIndex = this.model.getTabbedIndex();
        this.model.setTabbedIndex(index);
        this.model.getBrowser().setSelectedPane(index);
        this.setLensVisible(this.isLensVisible(), oldIndex);
    }

    void maximizeWindow() {
        JComponent c = this.model.getBrowser().getUI();
        c.setBounds(c.getBounds());
    }

    void enableSliders(boolean b) {
        this.controlPane.enableSliders(b);
    }

    boolean saveSettingsOnClose() {
        return this.toolBar.saveSettingsOnClose();
    }

    void setChannelActive(int index) {
        this.controlPane.setChannelActive(index);
    }

    public void setOnScreen() {
        if (this.model != null) {
            Browser browser = this.model.getBrowser();
            if (browser != null) {
                Dimension size = browser.getUI().getPreferredSize();
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int width = 9 * (screen.width / 10);
                int height = 9 * (screen.height / 10);
                if (size.width > width || size.height > height) {
                    this.setSize(width, height);
                } else {
                    this.pack();
                }
            } else {
                this.pack();
            }
            UIUtilities.incrementRelativeToAndShow(this.model.getRequesterBounds(), this);
        } else {
            this.pack();
            UIUtilities.incrementRelativeToAndShow(null, this);
        }
    }

    static {
        colors.put(ImagePaintingFactory.UNIT_BAR_COLOR, "Gray");
        colors.put(Color.ORANGE, "Orange");
        colors.put(Color.YELLOW, "Yellow");
        colors.put(Color.BLACK, "Black");
        colors.put(INDIGO, "Indigo");
        colors.put(VIOLET, "Violet");
        colors.put(Color.RED, "Red");
        colors.put(Color.GREEN, "Green");
        colors.put(Color.BLUE, "Blue");
        backgrounds = new LinkedHashMap<Color, String>();
        backgrounds.put(ImagePaintingFactory.DEFAULT_BACKGROUND, "Default background");
        backgrounds.put(Color.WHITE, "White");
        backgrounds.put(Color.BLACK, "Black");
        backgrounds.put(Color.GRAY, "Grey");
        backgrounds.put(Color.LIGHT_GRAY, "Light Grey");
    }
}

