/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import omeis.providers.re.data.PlaneDef;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.RenderingControlLoader;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.player.ChannelPlayer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.util.image.geom.Factory;

class ImViewerModel {
    static final int RATING_ONE = 3;
    static final int RATING_TWO = 4;
    static final int RATING_THREE = 5;
    static final int RATING_FOUR = 6;
    static final int RATING_FIVE = 7;
    private static final int THUMB_MAX_WIDTH = 48;
    private static final int THUMB_MAX_HEIGHT = 48;
    private long pixelsID;
    private long imageID;
    private String imageName;
    private int state;
    private ImViewer component;
    private DataLoader currentLoader;
    private Browser browser;
    private RenderingControl rndControl;
    private Renderer renderer;
    private ChannelPlayer player;
    private int sizeX;
    private int sizeY;
    private double factor;
    private BufferedImage imageIcon;
    private Rectangle requesterBounds;
    private boolean zoomFitToWindow;
    private int tabbedIndex;
    private boolean textVisible;
    private boolean playingMovie;

    private void computeSizes() {
        if (this.sizeX == -1 && this.sizeY == -1) {
            double y;
            this.sizeX = 48;
            this.sizeY = 48;
            double x = (double)this.sizeX / (double)this.getMaxX();
            this.factor = x > (y = (double)this.sizeY / (double)this.getMaxY()) ? x : y;
            double ratio = (double)this.getMaxX() / (double)this.getMaxY();
            if (ratio < 1.0) {
                this.sizeX = (int)((double)this.sizeX * ratio);
            } else if (ratio > 1.0 && ratio != 0.0) {
                this.sizeY = (int)((double)this.sizeY * (1.0 / ratio));
            }
        }
    }

    ImViewerModel(long pixelsID, long imageID, String name, Rectangle bounds) {
        this.pixelsID = pixelsID;
        this.imageID = imageID;
        this.imageName = name;
        this.requesterBounds = bounds;
        this.state = 1;
        this.sizeY = -1;
        this.sizeX = -1;
        this.zoomFitToWindow = false;
        this.tabbedIndex = 0;
        this.textVisible = true;
    }

    void initialize(ImViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, this.imageID);
    }

    boolean isSameDisplay(ImViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.pixelsID == this.pixelsID && other.imageID == this.imageID;
    }

    String getImageName() {
        return this.imageName;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.state = 7;
        ImViewerAgent.getRegistry().getImageService().shutDown(this.pixelsID);
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        if (this.renderer != null) {
            this.renderer.discard();
        }
        if (this.player == null) {
            return;
        }
        this.player.setPlayerState(1);
        this.player = null;
    }

    int getMaxX() {
        return this.rndControl.getPixelsDimensionsX();
    }

    int getMaxY() {
        return this.rndControl.getPixelsDimensionsY();
    }

    int getMaxZ() {
        return this.rndControl.getPixelsDimensionsZ() - 1;
    }

    int getMaxT() {
        return this.rndControl.getPixelsDimensionsT() - 1;
    }

    int getDefaultZ() {
        return this.rndControl.getDefaultZ();
    }

    int getDefaultT() {
        return this.rndControl.getDefaultT();
    }

    String getColorModel() {
        return this.rndControl.getModel();
    }

    int getRatingLevel() {
        return 4;
    }

    ChannelMetadata[] getChannelData() {
        return this.rndControl.getChannelData();
    }

    ChannelMetadata getChannelData(int index) {
        return this.rndControl.getChannelData(index);
    }

    Color getChannelColor(int w) {
        return this.rndControl.getRGBA(w);
    }

    boolean isChannelActive(int w) {
        return this.rndControl.isActive(w);
    }

    void fireRenderingControlLoading() {
        this.currentLoader = new RenderingControlLoader(this.component, this.pixelsID, false);
        this.currentLoader.load();
        this.state = 2;
    }

    void reloadRenderingControl() {
        this.currentLoader = new RenderingControlLoader(this.component, this.pixelsID, true);
        this.currentLoader.load();
        this.state = 2;
    }

    void fireImageRetrieval() {
        PlaneDef pDef = new PlaneDef(0, this.getDefaultT());
        pDef.setZ(this.getDefaultZ());
        this.state = 3;
        OmeroImageService os = ImViewerAgent.getRegistry().getImageService();
        try {
            this.component.setImage(os.renderImage(this.pixelsID, pDef));
        }
        catch (Exception e) {
            this.component.reload(e);
        }
    }

    BufferedImage getSplitComponentImage() throws RenderingServiceException, DSOutOfServiceException {
        PlaneDef pDef = new PlaneDef(0, this.getDefaultT());
        pDef.setZ(this.getDefaultZ());
        OmeroImageService os = ImViewerAgent.getRegistry().getImageService();
        return os.renderImage(this.pixelsID, pDef);
    }

    void setRenderingControl(RenderingControl rndControl) {
        this.rndControl = rndControl;
        if (this.renderer == null) {
            this.renderer = RendererFactory.createRenderer(this.component, rndControl);
            this.state = 9;
        } else {
            this.renderer.setRenderingControl(rndControl);
        }
    }

    Browser getBrowser() {
        return this.browser;
    }

    void setZoomFactor(double factor) {
        this.browser.setZoomFactor(factor);
    }

    double getZoomFactor() {
        return this.browser.getZoomFactor();
    }

    void setZoomFitToWindow(boolean option) {
        this.zoomFitToWindow = option;
    }

    boolean getZoomFitToWindow() {
        return this.zoomFitToWindow;
    }

    void setImage(BufferedImage image) {
        this.state = 6;
        this.browser.setRenderedImage(image);
        this.computeSizes();
        this.imageIcon = Factory.magnifyImage(this.factor, image);
    }

    void setColorModel(String colorModel) throws RenderingServiceException, DSOutOfServiceException {
        if ("greyscale".equals(colorModel)) {
            this.rndControl.setModel(colorModel);
        } else if ("rgb".equals(colorModel) || "hsb".equals(colorModel)) {
            this.rndControl.setModel("hsb");
        }
    }

    void setSelectedXYPlane(int z, int t) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setDefaultT(t);
        this.rndControl.setDefaultZ(z);
    }

    void setChannelColor(int index, Color c) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setRGBA(index, c);
    }

    void setChannelActive(int index, boolean b) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setActive(index, b);
    }

    int getMaxC() {
        return this.rndControl.getPixelsDimensionsC();
    }

    int getActiveChannelsCount() {
        int active = 0;
        for (int i = 0; i < this.getMaxC(); ++i) {
            if (!this.rndControl.isActive(i)) continue;
            ++active;
        }
        return active;
    }

    List getActiveChannels() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (int i = 0; i < this.getMaxC(); ++i) {
            if (!this.rndControl.isActive(i)) continue;
            active.add(new Integer(i));
        }
        return active;
    }

    void playMovie(boolean play) throws RenderingServiceException, DSOutOfServiceException {
        if (this.player != null && !play) {
            this.player.setPlayerState(1);
            List l = this.player.getChannels();
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    int index = (Integer)i.next();
                    this.setChannelActive(index, true);
                }
            }
            this.player = null;
            this.state = 6;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImViewerModel.this.player = new ChannelPlayer(ImViewerModel.this.component);
                ImViewerModel.this.player.setPlayerState(0);
            }
        });
        this.state = 8;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    double getGlobalMinimum(int index) {
        return this.getChannelData(index).getGlobalMin();
    }

    double getGlobalMaximum(int index) {
        return this.getChannelData(index).getGlobalMax();
    }

    BufferedImage getDisplayedImage() {
        return this.browser.getDisplayedImage();
    }

    BufferedImage getOriginalImage() {
        return this.browser.getRenderedImage();
    }

    BufferedImage getGridImage() {
        return this.browser.getGridImage();
    }

    float getPixelsSizeX() {
        return this.rndControl.getPixelsSizeX();
    }

    float getPixelsSizeY() {
        return this.rndControl.getPixelsSizeY();
    }

    float getPixelsSizeZ() {
        return this.rndControl.getPixelsSizeZ();
    }

    boolean isUnitBar() {
        return this.browser.isUnitBar();
    }

    BufferedImage getImageIcon() {
        return this.imageIcon;
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    long getPixelsID() {
        return this.pixelsID;
    }

    int getTabbedIndex() {
        return this.tabbedIndex;
    }

    void setTabbedIndex(int index) {
        this.tabbedIndex = index;
    }

    boolean[] hasRGB() {
        boolean[] rgb = new boolean[]{this.rndControl.hasActiveChannelRed(), this.rndControl.hasActiveChannelGreen(), this.rndControl.hasActiveChannelBlue()};
        return rgb;
    }

    boolean isTextVisible() {
        return this.textVisible;
    }

    void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    BufferedImage getAnnotateImage() {
        return this.browser.getAnnotateImage();
    }

    long getImageID() {
        return this.imageID;
    }

    void saveRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.saveCurrentSettings();
    }

    void setPlayingMovie(boolean b) {
        this.playingMovie = b;
    }

    boolean isPlayingMovie() {
        return this.playingMovie;
    }

    boolean isChannelRed(int index) {
        return this.rndControl.isChannelRed(index);
    }

    boolean isChannelGreen(int index) {
        return this.rndControl.isChannelGreen(index);
    }

    boolean isChannelBlue(int index) {
        return this.rndControl.isChannelBlue(index);
    }

    Map getActiveChannelsMap() {
        List l = this.getActiveChannels();
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(l.size());
        for (Integer index : l) {
            m.put(index, this.getChannelColor(index));
        }
        return m;
    }
}

