/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerComponent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.env.ui.TaskBar;

public class ImViewerFactory
implements ChangeListener {
    private static final ImViewerFactory singleton = new ImViewerFactory();
    private Set<ImViewer> viewers = new HashSet<ImViewer>();
    private JMenu windowMenu = new JMenu("Viewers");
    private boolean isAttached = false;

    static Set getViewers() {
        return ImViewerFactory.singleton.viewers;
    }

    static JMenu getWindowMenu() {
        return ImViewerFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return ImViewerFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (ImViewerFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = HiViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, ImViewerFactory.singleton.windowMenu);
        ImViewerFactory.singleton.isAttached = true;
    }

    public static ImViewer getImageViewer(long pixelsID, long imageID, String name, Rectangle bounds) {
        ImViewerModel model = new ImViewerModel(pixelsID, imageID, name, bounds);
        return singleton.getViewer(model);
    }

    public static ImViewer getImageViewer(long pixelsID) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getPixelsID() != pixelsID) continue;
            return imViewerComponent;
        }
        return null;
    }

    private ImViewerFactory() {
    }

    private ImViewer getViewer(ImViewerModel model) {
        for (ImViewerComponent imViewerComponent : this.viewers) {
            if (!model.isSameDisplay(imViewerComponent.getModel())) continue;
            return imViewerComponent;
        }
        ImViewerComponent imViewerComponent = new ImViewerComponent(model);
        imViewerComponent.initialize();
        imViewerComponent.addChangeListener(this);
        this.viewers.add(imViewerComponent);
        return imViewerComponent;
    }

    public void stateChanged(ChangeEvent ce) {
        ImViewerComponent comp = (ImViewerComponent)ce.getSource();
        if (comp.getState() == 7) {
            this.viewers.remove(comp);
        }
        if (this.viewers.size() == 0) {
            TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
            tb.removeFromMenu(0, this.windowMenu);
            this.isAttached = false;
        }
    }
}

