/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ArchivedAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ChannelMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.InfoAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.LensAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.MovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PlayMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ROIToolAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RateImageAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RendererAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.TextVisibleAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomFitAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomInAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomOutAction;
import org.openmicroscopy.shoola.agents.imviewer.util.InfoDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;

class ImViewerControl
implements ActionListener,
ChangeListener,
ComponentListener,
PropertyChangeListener {
    static final Integer CLOSE = new Integer(0);
    static final Integer RENDERER = new Integer(1);
    static final Integer MOVIE = new Integer(2);
    static final Integer SAVE = new Integer(3);
    static final Integer ZOOM_25 = new Integer(4);
    static final Integer ZOOM_50 = new Integer(5);
    static final Integer ZOOM_75 = new Integer(6);
    static final Integer ZOOM_100 = new Integer(7);
    static final Integer ZOOM_125 = new Integer(8);
    static final Integer ZOOM_150 = new Integer(9);
    static final Integer ZOOM_175 = new Integer(10);
    static final Integer ZOOM_200 = new Integer(11);
    static final Integer ZOOM_225 = new Integer(12);
    static final Integer ZOOM_250 = new Integer(13);
    static final Integer ZOOM_275 = new Integer(14);
    static final Integer ZOOM_300 = new Integer(15);
    static final Integer ZOOM_FIT_TO_WINDOW = new Integer(16);
    static final Integer LENS = new Integer(17);
    static final Integer GREY_SCALE_MODEL = new Integer(18);
    static final Integer RGB_MODEL = new Integer(19);
    static final Integer HSB_MODEL = new Integer(20);
    static final Integer RATING_ONE = new Integer(21);
    static final Integer RATING_TWO = new Integer(22);
    static final Integer RATING_THREE = new Integer(23);
    static final Integer RATING_FOUR = new Integer(24);
    static final Integer RATING_FIVE = new Integer(25);
    static final Integer CHANNEL_MOVIE = new Integer(26);
    static final Integer UNIT_BAR = new Integer(27);
    static final Integer UNIT_BAR_ONE = new Integer(28);
    static final Integer UNIT_BAR_TWO = new Integer(29);
    static final Integer UNIT_BAR_FIVE = new Integer(30);
    static final Integer UNIT_BAR_TEN = new Integer(31);
    static final Integer UNIT_BAR_TWENTY = new Integer(32);
    static final Integer UNIT_BAR_FIFTY = new Integer(33);
    static final Integer UNIT_BAR_HUNDRED = new Integer(34);
    static final Integer UNIT_BAR_CUSTOM = new Integer(35);
    static final Integer COLOR_PICKER = new Integer(36);
    static final Integer DOWNLOAD = new Integer(37);
    static final Integer TEXT_VISIBLE = new Integer(38);
    static final Integer MEASUREMENT_TOOL = new Integer(39);
    static final Integer IMAGE_DETAILS = new Integer(40);
    static final Integer ZOOM_IN = new Integer(41);
    static final Integer ZOOM_OUT = new Integer(42);
    static final Integer ZOOM_FIT = new Integer(43);
    static final Integer PLAY_MOVIE = new Integer(44);
    private ImViewer model;
    private ImViewerUI view;
    private Map<Integer, ViewerAction> actionsMap;
    private int historyState;
    private int colorPickerIndex;
    private MoviePlayerDialog moviePlayer;

    private void createActions() {
        this.actionsMap.put(RENDERER, new RendererAction(this.model));
        this.actionsMap.put(MOVIE, new MovieAction(this.model));
        this.actionsMap.put(SAVE, new SaveAction(this.model));
        this.actionsMap.put(ZOOM_25, new ZoomAction(this.model, 0));
        this.actionsMap.put(ZOOM_50, new ZoomAction(this.model, 1));
        this.actionsMap.put(ZOOM_75, new ZoomAction(this.model, 2));
        this.actionsMap.put(ZOOM_100, new ZoomAction(this.model, 3));
        this.actionsMap.put(ZOOM_125, new ZoomAction(this.model, 4));
        this.actionsMap.put(ZOOM_150, new ZoomAction(this.model, 5));
        this.actionsMap.put(ZOOM_175, new ZoomAction(this.model, 6));
        this.actionsMap.put(ZOOM_200, new ZoomAction(this.model, 7));
        this.actionsMap.put(ZOOM_225, new ZoomAction(this.model, 8));
        this.actionsMap.put(ZOOM_250, new ZoomAction(this.model, 9));
        this.actionsMap.put(ZOOM_275, new ZoomAction(this.model, 10));
        this.actionsMap.put(ZOOM_300, new ZoomAction(this.model, 11));
        this.actionsMap.put(ZOOM_FIT_TO_WINDOW, new ZoomAction(this.model, 12));
        this.actionsMap.put(LENS, new LensAction(this.model));
        this.actionsMap.put(GREY_SCALE_MODEL, new ColorModelAction(this.model, 0));
        this.actionsMap.put(RGB_MODEL, new ColorModelAction(this.model, 1));
        this.actionsMap.put(HSB_MODEL, new ColorModelAction(this.model, 2));
        this.actionsMap.put(RATING_ONE, new RateImageAction(this.model, 0));
        this.actionsMap.put(RATING_TWO, new RateImageAction(this.model, 1));
        this.actionsMap.put(RATING_THREE, new RateImageAction(this.model, 2));
        this.actionsMap.put(RATING_FOUR, new RateImageAction(this.model, 3));
        this.actionsMap.put(RATING_FIVE, new RateImageAction(this.model, 4));
        this.actionsMap.put(CHANNEL_MOVIE, new ChannelMovieAction(this.model));
        this.actionsMap.put(UNIT_BAR, new UnitBarAction(this.model));
        this.actionsMap.put(UNIT_BAR_ONE, new UnitBarSizeAction(this.model, 0));
        this.actionsMap.put(UNIT_BAR_TWO, new UnitBarSizeAction(this.model, 1));
        this.actionsMap.put(UNIT_BAR_FIVE, new UnitBarSizeAction(this.model, 2));
        this.actionsMap.put(UNIT_BAR_TEN, new UnitBarSizeAction(this.model, 3));
        this.actionsMap.put(UNIT_BAR_TWENTY, new UnitBarSizeAction(this.model, 4));
        this.actionsMap.put(UNIT_BAR_FIFTY, new UnitBarSizeAction(this.model, 5));
        this.actionsMap.put(UNIT_BAR_HUNDRED, new UnitBarSizeAction(this.model, 6));
        this.actionsMap.put(UNIT_BAR_CUSTOM, new UnitBarSizeAction(this.model, 7));
        this.actionsMap.put(COLOR_PICKER, new ColorPickerAction(this.model));
        this.actionsMap.put(DOWNLOAD, new ArchivedAction(this.model));
        this.actionsMap.put(TEXT_VISIBLE, new TextVisibleAction(this.model));
        this.actionsMap.put(MEASUREMENT_TOOL, new ROIToolAction(this.model));
        this.actionsMap.put(IMAGE_DETAILS, new InfoAction(this.model));
        this.actionsMap.put(ZOOM_IN, new ZoomInAction(this.model));
        this.actionsMap.put(ZOOM_OUT, new ZoomOutAction(this.model));
        this.actionsMap.put(ZOOM_FIT, new ZoomFitAction(this.model));
        this.actionsMap.put(PLAY_MOVIE, new PlayMovieAction(this.model));
    }

    private void attachListeners() {
        JMenu menu = ImViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImViewerControl.this.model.discard();
            }

            public void windowDeiconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(false);
            }

            public void windowIconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(true);
            }
        });
        this.view.getLoadingWindow().addPropertyChangeListener("closed", this);
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = ImViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((ImViewer)i.next())));
        }
    }

    ImViewerControl() {
    }

    void initialize(ImViewer model, ImViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.historyState = -1;
        this.colorPickerIndex = -1;
        this.actionsMap = new HashMap<Integer, ViewerAction>();
        this.createActions();
        model.addChangeListener(this);
        model.addPropertyChangeListener(this);
        this.attachListeners();
        ImViewerFactory.attachWindowMenuToTaskBar();
    }

    ViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void setSelectedXYPlane(int z, int t) {
        this.model.setSelectedXYPlane(z, t);
    }

    int getHistoryState() {
        return this.historyState;
    }

    void setHistoryState(int s) {
        this.historyState = s;
    }

    void showColorPicker(int index) {
        this.colorPickerIndex = index;
        Color c = this.model.getChannelColor(index);
        ColourPicker dialog = new ColourPicker(this.view, c);
        dialog.addPropertyChangeListener(this);
        UIUtilities.setLocationRelativeToAndShow(this.view, dialog);
    }

    MoviePlayerDialog getMoviePlayer() {
        if (this.moviePlayer != null) {
            return this.moviePlayer;
        }
        this.moviePlayer = new MoviePlayerDialog(this.view, this.model);
        this.moviePlayer.addPropertyChangeListener("close", this);
        return this.moviePlayer;
    }

    public void actionPerformed(ActionEvent e) {
        String m = this.model.getColorModel();
        ViewerAction a = null;
        if (m.equals("rgb") || m.equals("hsb")) {
            a = this.getAction(GREY_SCALE_MODEL);
        } else if (m.equals("greyscale")) {
            a = this.getAction(RGB_MODEL);
        }
        a.actionPerformed(e);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            this.view.setSelectedPane(pane.getSelectedIndex());
            return;
        }
        int state = this.model.getState();
        switch (state) {
            case 7: {
                LoadingWindow window = this.view.getLoadingWindow();
                window.setVisible(false);
                window.dispose();
                this.view.setVisible(false);
                if (this.view.isLensVisible()) {
                    this.view.setLensVisible(false, this.model.getSelectedIndex());
                }
                this.view.dispose();
                this.historyState = state;
                break;
            }
            case 2: {
                UIUtilities.centerAndShow(this.view.getLoadingWindow());
                this.historyState = state;
                break;
            }
            case 3: {
                if (this.historyState == 4) {
                    this.view.getLoadingWindow().setVisible(false);
                }
                this.view.onStateChange(false);
                this.historyState = state;
                break;
            }
            case 6: {
                this.view.getLoadingWindow().setVisible(false);
                if (this.historyState == 8) {
                    this.view.onStateChange(false);
                    break;
                }
                this.view.onStateChange(true);
                this.historyState = state;
                break;
            }
            case 8: {
                this.historyState = 8;
                this.view.onStateChange(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("zSelected".equals(propName)) {
            this.view.setZSection((Integer)pce.getNewValue());
        } else if ("tSelected".equals(propName)) {
            this.view.setTimepoint((Integer)pce.getNewValue());
        } else if ("channelSelected".equals(propName)) {
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            for (Integer index : map.keySet()) {
                this.model.setChannelSelection(index, (Boolean)map.get(index));
            }
        } else if ("closed".equals(propName)) {
            this.model.discard();
        } else if ("render_plane".equals(propName)) {
            this.model.renderXYPlane();
        } else if ("selectedChannel".equals(propName)) {
            if (this.model.getColorModel().equals("greyscale")) {
                int c = (Integer)pce.getNewValue();
                for (int i = 0; i < this.model.getMaxC(); ++i) {
                    this.model.setChannelActive(i, i == c);
                }
                this.model.displayChannelMovie();
            }
        } else if ("info".equals(propName)) {
            int index = (Integer)pce.getNewValue();
            ChannelMetadata data = this.model.getChannelMetadata(index);
            if (data != null) {
                InfoDialog dialog = new InfoDialog(this.model.getUI(), data);
                dialog.addPropertyChangeListener(this);
                UIUtilities.setLocationRelativeToAndShow(this.view, dialog);
            } else {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Channel info", "No metadata for the selected channel.");
            }
        } else if ("channelColor".equals(propName) || "channelColor".equals(propName)) {
            this.colorPickerIndex = (Integer)pce.getNewValue();
            this.showColorPicker(this.colorPickerIndex);
        } else if ("colour".equals(propName)) {
            Color c = (Color)pce.getNewValue();
            if (this.colorPickerIndex != -1) {
                this.model.setChannelColor(this.colorPickerIndex, c);
            }
        } else if ("unitBarValue".equals(propName)) {
            double v = (Double)pce.getNewValue();
            this.model.setUnitBarSize(v);
        } else if (!"update".equals(propName)) {
            boolean b;
            if ("iconified".equals(propName)) {
                if (this.moviePlayer != null) {
                    this.model.playMovie(false, false);
                }
                this.view.onIconified();
            } else if (LensComponent.LENS_LOCATION_PROPERTY.equals(propName)) {
                this.view.scrollToNode((Rectangle)pce.getNewValue());
            } else if ("close".equals(propName)) {
                this.model.playMovie(false, false);
            } else if ("stateChanged".equals(propName) && !(b = ((Boolean)pce.getNewValue()).booleanValue()) && !this.getMoviePlayer().isVisible()) {
                ((PlayMovieAction)this.getAction(PLAY_MOVIE)).setActionIcon(true);
                this.model.playMovie(false, false);
            }
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.model.isZoomFitToWindow()) {
            this.model.setZoomFactor(-1.0, 12);
        }
        this.view.maximizeWindow();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

