/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.events.iviewer.ChannelSelection;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurePlane;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.util.ImageDetailsDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.UnitBarSizeDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.util.archived.view.Downloader;
import org.openmicroscopy.shoola.agents.util.archived.view.DownloaderFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class ImViewerComponent
extends AbstractComponent
implements ImViewer {
    private static final String RENDERING_MSG = "Render image";
    private ImViewerModel model;
    private ImViewerControl controller;
    private ImViewerUI view;
    private List historyActiveChannels;
    private boolean newPlane;

    private String getStatusText() {
        String text = "";
        text = text + "Z=" + (this.model.getDefaultZ() + 1) + "/" + (this.model.getMaxZ() + 1);
        text = text + " T=" + this.model.getDefaultT() + "/" + this.model.getMaxT();
        return text;
    }

    private void postMeasurePlane() {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        MeasurePlane event = new MeasurePlane(this.model.getPixelsID(), this.model.getDefaultZ(), this.model.getDefaultT(), this.model.getZoomFactor());
        bus.post(event);
    }

    private void postViewerState(int index) {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        ViewerState event = new ViewerState(this.model.getPixelsID(), index);
        bus.post(event);
    }

    private void postActiveChannelSelection(int index) {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        ChannelSelection event = new ChannelSelection(this.model.getPixelsID(), this.model.getActiveChannelsMap(), index);
        bus.post(event);
    }

    ImViewerComponent(ImViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ImViewerControl();
        this.view = new ImViewerUI(model.getImageName());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
    }

    ImViewerModel getModel() {
        return this.model;
    }

    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                this.model.fireRenderingControlLoading();
                this.fireStateChange();
                break;
            }
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                this.view.deIconify();
                UIUtilities.centerOnScreen(this.view);
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 7) {
            MessageBox msg;
            try {
                if (this.view.saveSettingsOnClose()) {
                    this.model.saveRndSettings();
                }
            }
            catch (Exception e) {
                LogMessage msg2 = new LogMessage();
                msg2.println("Cannot save rendering settings. ");
                msg2.print(e);
                ImViewerAgent.getRegistry().getLogger().error((Object)this, msg2);
            }
            if (this.model.getBrowser().hasAnnotationToSave() && (msg = new MessageBox(this.view, "Save Annotation", "Do you want to save the annotation before closing?")).centerMsgBox() == 1) {
                this.model.getBrowser().saveAnnotation();
            }
            this.postViewerState(0);
            this.model.discard();
            this.fireStateChange();
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public void setStatus(String description, int perc) {
        if (this.model.getState() == 7) {
            return;
        }
        this.view.setStatus(description);
    }

    public void setZoomFactor(double factor, int zoomIndex) {
        if (factor != -1.0 && (factor > 3.0 || factor < 0.25)) {
            throw new IllegalArgumentException("The zoom factor is value between 0.25 and 3.0");
        }
        this.model.setZoomFitToWindow(factor == -1.0);
        this.model.setZoomFactor(factor);
        this.view.setZoomFactor(zoomIndex);
        if (this.view.isLensVisible() && this.model.getTabbedIndex() == 0) {
            this.view.setImageZoomFactor((float)this.model.getZoomFactor());
            this.view.scrollLens();
        }
        this.postMeasurePlane();
    }

    public boolean isZoomFitToWindow() {
        return this.model.getZoomFitToWindow();
    }

    public void setRateImage(int level) {
    }

    public void setColorModel(int key) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            List channels = this.model.getActiveChannels();
            switch (key) {
                case 0: {
                    this.historyActiveChannels = this.model.getActiveChannels();
                    this.model.setColorModel("greyscale");
                    if (channels != null && channels.size() > 1) {
                        Iterator i = channels.iterator();
                        int j = 0;
                        while (i.hasNext()) {
                            int index = (Integer)i.next();
                            this.setChannelActive(index, j == 0);
                            ++j;
                        }
                        break;
                    }
                    if (channels != null && channels.size() != 0) break;
                    this.setChannelActive(0, true);
                    break;
                }
                case 1: 
                case 2: {
                    this.model.setColorModel("hsb");
                    if (this.historyActiveChannels != null && this.historyActiveChannels.size() != 0) {
                        Iterator i = this.historyActiveChannels.iterator();
                        while (i.hasNext()) {
                            int index = (Integer)i.next();
                            this.setChannelActive(index, true);
                        }
                    } else {
                        if (channels == null || channels.size() == 0) {
                            this.setChannelActive(0, true);
                            break;
                        }
                        Iterator i = channels.iterator();
                        while (i.hasNext()) {
                            int index = (Integer)i.next();
                            this.setChannelActive(index, true);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Color model not supported");
                }
            }
            this.firePropertyChange("colorModelChanged", new Integer(1), new Integer(-1));
            this.view.setColorModel(key);
            this.renderXYPlane();
        }
        catch (Exception ex) {
            this.reload(ex);
        }
    }

    public void setSelectedXYPlane(int z, int t) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        int defaultZ = this.model.getDefaultZ();
        int defaultT = this.model.getDefaultT();
        if (defaultZ == z && defaultT == t) {
            return;
        }
        try {
            if (defaultZ != z) {
                this.firePropertyChange("zSelected", new Integer(defaultZ), new Integer(z));
            }
            if (defaultT != t) {
                this.firePropertyChange("tSelected", new Integer(defaultT), new Integer(t));
            }
            this.newPlane = true;
            this.model.setSelectedXYPlane(z, t);
            this.renderXYPlane();
        }
        catch (Exception ex) {
            this.reload(ex);
        }
    }

    public void setImage(BufferedImage image) {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_IMAGE state.");
        }
        if (this.newPlane) {
            this.postMeasurePlane();
        }
        this.newPlane = false;
        this.model.setImage(image);
        this.view.setStatus(this.getStatusText());
        if (!this.model.isPlayingMovie()) {
            this.view.setIconImage(this.model.getImageIcon());
        }
        if (this.view.isLensVisible()) {
            this.view.setLensPlaneImage();
        }
        this.fireStateChange();
    }

    public void playChannelMovie(boolean play) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        if (this.model.getState() != 6) {
            return;
        }
        try {
            this.model.playMovie(play);
            if (!play) {
                this.displayChannelMovie();
                this.controller.setHistoryState(6);
            }
            this.fireStateChange();
        }
        catch (Exception ex) {
            this.reload(ex);
        }
    }

    public void setChannelColor(int index, Color c) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            this.model.setChannelColor(index, c);
            this.view.setChannelColor(index, c);
            if (!this.model.isChannelActive(index)) {
                this.setChannelActive(index, true);
                this.view.setChannelActive(index);
            }
            if ("greyscale".equals(this.model.getColorModel())) {
                this.setColorModel(1);
            } else {
                this.renderXYPlane();
            }
        }
        catch (Exception e) {
            Registry reg = ImViewerAgent.getRegistry();
            LogMessage msg = new LogMessage();
            msg.println("Cannot set the color of channel " + index);
            msg.print(e);
            reg.getLogger().error((Object)this, msg);
            reg.getUserNotifier().notifyError("Set channel color", "Cannot set the color of channel " + index, e);
        }
        this.firePropertyChange("channelColorChanged", new Integer(index - 1), new Integer(index));
        this.postActiveChannelSelection(0);
    }

    public void setChannelSelection(int index, boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            if (this.model.getColorModel().equals("greyscale")) {
                if (this.model.isChannelActive(index)) {
                    return;
                }
                for (int i = 0; i < this.model.getMaxC(); ++i) {
                    boolean c = i == index;
                    this.model.setChannelActive(i, c);
                    if (!c) continue;
                    this.firePropertyChange("channelActive", new Integer(index - 1), new Integer(index));
                }
            } else {
                this.model.setChannelActive(index, b);
                this.firePropertyChange("channelActive", new Integer(index - 1), new Integer(index));
            }
            this.view.setChannelsSelection();
            this.renderXYPlane();
            this.postActiveChannelSelection(1);
        }
        catch (Exception ex) {
            this.reload(ex);
        }
    }

    public void setRenderingControl(RenderingControl result) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method can't be invoked in the LOADING_RENDERING_CONTROL.");
        }
        this.model.setRenderingControl(result);
        this.fireStateChange();
        this.model.getRenderer().addPropertyChangeListener(this.controller);
        LoadingWindow window = this.view.getLoadingWindow();
        window.setStatus("rendering settings. Loading: metadata");
        window.setProgress(50);
        this.view.buildComponents();
        this.view.setOnScreen();
        this.view.setStatus(RENDERING_MSG);
        this.renderXYPlane();
    }

    public void renderXYPlane() {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        this.model.fireImageRetrieval();
        this.newPlane = false;
        this.fireStateChange();
    }

    public void setChannelActive(int index, boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            this.model.setChannelActive(index, b);
            if (b) {
                this.firePropertyChange("channelActive", new Integer(index - 1), new Integer(index));
            }
        }
        catch (Exception ex) {
            this.reload(ex);
        }
    }

    public void displayChannelMovie() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        this.view.setChannelsSelection();
        this.renderXYPlane();
    }

    public int getMaxC() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxC();
    }

    public int getMaxT() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxT();
    }

    public int getMaxZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxZ();
    }

    public void showRenderer() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        JFrame f = this.model.getRenderer().getUI();
        UIUtilities.setLocationRelativeToAndShow(this.view, f);
    }

    public String getImageName() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.model.getImageName();
    }

    public String getColorModel() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getColorModel();
    }

    public JFrame getUI() {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW state.");
            }
        }
        return this.view;
    }

    public void iconified(boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                return;
            }
        }
        Boolean newValue = Boolean.FALSE;
        Boolean oldValue = Boolean.TRUE;
        int index = 2;
        if (b) {
            newValue = Boolean.TRUE;
            oldValue = Boolean.FALSE;
            index = 1;
        }
        this.postViewerState(index);
        this.firePropertyChange("iconified", oldValue, newValue);
    }

    public int getDefaultZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getDefaultZ();
    }

    public int getDefaultT() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getDefaultT();
    }

    public List getImageComponents(String colorModel) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        if (this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        List l = this.model.getActiveChannels();
        if (l.size() < 2) {
            return null;
        }
        Iterator i = l.iterator();
        String oldColorModel = this.model.getColorModel();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(l.size());
        try {
            int index;
            this.model.setColorModel(colorModel);
            while (i.hasNext()) {
                index = (Integer)i.next();
                for (int j = 0; j < this.model.getMaxC(); ++j) {
                    this.model.setChannelActive(j, j == index);
                }
                images.add(this.model.getSplitComponentImage());
            }
            this.model.setColorModel(oldColorModel);
            i = l.iterator();
            while (i.hasNext()) {
                index = (Integer)i.next();
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception ex) {
            this.reload(ex);
        }
        return images;
    }

    public List getGridImages() {
        ArrayList<BufferedImage> images;
        block15: {
            switch (this.model.getState()) {
                case 1: 
                case 2: 
                case 7: {
                    throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
                }
            }
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            List active = this.model.getActiveChannels();
            int maxC = this.model.getMaxC();
            images = new ArrayList<BufferedImage>(maxC);
            try {
                if (this.model.getColorModel().equals("greyscale")) {
                    int k;
                    for (k = 0; k < maxC; ++k) {
                        this.model.setChannelActive(k, true);
                        for (int i = 0; i < maxC; ++i) {
                            if (i == k) continue;
                            this.model.setChannelActive(i, false);
                        }
                        images.add(this.model.getSplitComponentImage());
                    }
                    for (k = 0; k < maxC; ++k) {
                        this.model.setChannelActive(k, true);
                    }
                    this.model.setColorModel("hsb");
                    images.add(this.model.getSplitComponentImage());
                    this.model.setColorModel("greyscale");
                    for (k = 0; k < maxC; ++k) {
                        this.model.setChannelActive(k, false);
                    }
                    Iterator i = active.iterator();
                    while (i.hasNext()) {
                        int index = (Integer)i.next();
                        this.model.setChannelActive(index, true);
                    }
                    break block15;
                }
                for (int j = 0; j < maxC; ++j) {
                    if (this.model.isChannelActive(j)) {
                        for (int k = 0; k < maxC; ++k) {
                            this.model.setChannelActive(k, k == j);
                        }
                        images.add(this.model.getSplitComponentImage());
                        Iterator i = active.iterator();
                        while (i.hasNext()) {
                            int index = (Integer)i.next();
                            this.model.setChannelActive(index, true);
                        }
                        continue;
                    }
                    images.add(null);
                }
            }
            catch (Exception ex) {
                this.reload(ex);
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        return images;
    }

    public BufferedImage getImageForGrid(int index) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        if (!this.model.isChannelActive(index)) {
            return null;
        }
        if (this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        BufferedImage image = null;
        try {
            for (int k = 0; k < this.model.getMaxC(); ++k) {
                this.model.setChannelActive(k, k == index);
            }
            image = this.model.getSplitComponentImage();
            List active = this.model.getActiveChannels();
            Iterator i = active.iterator();
            while (i.hasNext()) {
                index = (Integer)i.next();
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception ex) {
            this.reload(ex);
        }
        return image;
    }

    public BufferedImage getDisplayedImage() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getDisplayedImage();
    }

    public float getPixelsSizeX() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getPixelsSizeX();
    }

    public float getPixelsSizeY() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getPixelsSizeY();
    }

    public float getPixelsSizeZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getPixelsSizeZ();
    }

    public String getViewTitle() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.view.getTitle();
    }

    public ChannelMetadata getChannelMetadata(int index) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.model.getChannelData(index);
    }

    public List getActiveChannels() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getActiveChannels();
    }

    public boolean isUnitBar() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.model.isUnitBar();
    }

    public void setUnitBar(boolean b) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        this.model.getBrowser().setUnitBar(b);
    }

    public int getHistoryState() {
        return this.controller.getHistoryState();
    }

    public Color getChannelColor(int index) {
        return this.model.getChannelColor(index);
    }

    public void setUnitBarSize(double size) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        this.model.getBrowser().setUnitBarSize(size);
    }

    public void showUnitBarSelection() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        UnitBarSizeDialog d = new UnitBarSizeDialog(this.view);
        d.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(d);
    }

    public void resetDefaults() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        this.view.setStatus(this.getStatusText());
        this.view.resetDefaults();
    }

    public String getUnitBarValue() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUnitBarValue();
    }

    public double getUnitBarSize() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUnitBarSize();
    }

    public Color getUnitBarColor() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUnitBarColor();
    }

    public ImageIcon getImageIcon() {
        return new ImageIcon(this.model.getImageIcon());
    }

    public boolean isLensVisible() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        return this.view.isLensVisible();
    }

    public void setLensVisible(boolean b) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        this.view.setLensVisible(b, this.model.getTabbedIndex());
    }

    public BufferedImage getZoomedLensImage() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getZoomedLensImage();
    }

    public void showMenu(int menuID, Component source, Point location) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        switch (menuID) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
        if (source == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (location == null) {
            throw new IllegalArgumentException("No point.");
        }
        if (this.model.getMaxC() == 1) {
            this.controller.showColorPicker(0);
        } else {
            this.view.showMenu(menuID, source, location);
        }
    }

    public void setReloaded(RenderingControl rndControl) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("The method can only be invoked in the LOADING_RENDERING_CONTROL state.");
        }
        this.model.setRenderingControl(rndControl);
        this.renderXYPlane();
    }

    public void reload(Exception e) {
        Logger logger = ImViewerAgent.getRegistry().getLogger();
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        if (e instanceof RenderingServiceException) {
            RenderingServiceException rse = (RenderingServiceException)e;
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(rse.getExtendedMessage());
            logMsg.print(rse);
            logger.error((Object)this, logMsg);
            if (this.newPlane) {
                MessageBox msg = new MessageBox(this.view, "Invalid Plane", "The selected plane contains invalid value. Do you want to close the viewer?");
                if (msg.centerMsgBox() == 1) {
                    this.discard();
                } else {
                    this.setImage(null);
                }
            } else {
                un.notifyError(" An error occured while modifying  the rendering settings.", logMsg.toString(), e.getCause());
            }
            this.newPlane = false;
        } else if (e instanceof DSOutOfServiceException) {
            MessageBox msg = new MessageBox(this.view, "Rendering timeout", "The rendering engine has timed out. Do you want to restart it?");
            if (msg.centerMsgBox() == 1) {
                logger.debug((Object)this, "Reload rendering Engine.");
                this.model.reloadRenderingControl();
                this.fireStateChange();
            } else {
                logger.debug((Object)this, e.getMessage());
                this.discard();
            }
        }
    }

    public void download() {
        Downloader dl = DownloaderFactory.getDownloader(this.view, ImViewerAgent.getRegistry(), this.model.getPixelsID());
        dl.activate();
    }

    public int getMaxX() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxX();
    }

    public int getMaxY() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxY();
    }

    public int getSelectedIndex() {
        return this.model.getTabbedIndex();
    }

    public void playMovie(boolean b, boolean visible) {
        MoviePlayerDialog d = this.controller.getMoviePlayer();
        boolean doClick = false;
        boolean wasVisible = false;
        if (visible) {
            b = true;
            UIUtilities.setLocationRelativeToAndShow(this.view, d);
        } else if (d.isVisible()) {
            b = false;
            wasVisible = true;
            d.setVisible(false);
        } else {
            doClick = true;
            d.setMovieIndex(301);
            d.setTimeRange(this.model.getDefaultT(), this.model.getMaxT());
        }
        this.model.setPlayingMovie(b);
        this.view.enableSliders(!b);
        this.controller.getAction(ImViewerControl.CHANNEL_MOVIE).setEnabled(!b);
        if (doClick) {
            d.addPropertyChangeListener("stateChanged", this.controller);
            if (b) {
                d.doClick(0);
            } else {
                d.doClick(1);
            }
        } else {
            d.removePropertyChangeListener("stateChanged", this.controller);
        }
        this.controller.getAction(ImViewerControl.PLAY_MOVIE).setEnabled(doClick);
        if (wasVisible) {
            this.controller.getAction(ImViewerControl.PLAY_MOVIE).setEnabled(true);
        }
    }

    public BufferedImage getGridImage() {
        return this.model.getBrowser().getGridImage();
    }

    public List getLensImageComponents(String colorModel) {
        if (!this.view.hasLensImage()) {
            return null;
        }
        if (this.model.getTabbedIndex() != 0) {
            return null;
        }
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        if (this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        List l = this.model.getActiveChannels();
        if (l.size() < 2) {
            return null;
        }
        Iterator i = l.iterator();
        String oldColorModel = this.model.getColorModel();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(l.size());
        try {
            int index;
            this.model.setColorModel(colorModel);
            while (i.hasNext()) {
                index = (Integer)i.next();
                for (int j = 0; j < this.model.getMaxC(); ++j) {
                    this.model.setChannelActive(j, j == index);
                }
                images.add(this.view.createZoomedLensImage(this.model.getSplitComponentImage()));
            }
            this.model.setColorModel(oldColorModel);
            i = l.iterator();
            while (i.hasNext()) {
                index = (Integer)i.next();
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception ex) {
            this.reload(ex);
        }
        return images;
    }

    public boolean isTextVisible() {
        return this.model.isTextVisible();
    }

    public void setTextVisible(boolean b) {
        this.model.setTextVisible(b);
        this.model.getBrowser().viewSplitImages();
    }

    public void showMeasurementTool() {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        MeasurementTool request = new MeasurementTool(this.model.getImageID(), this.model.getPixelsID(), this.model.getImageName(), this.model.getDefaultZ(), this.model.getDefaultT(), this.model.getActiveChannelsMap(), this.model.getZoomFactor(), this.view.getBounds());
        bus.post(request);
    }

    public void showImageDetails() {
        if (this.model.getState() != 6) {
            return;
        }
        ImageDetailsDialog d = new ImageDetailsDialog(this.view, this.model.getMaxX(), this.model.getMaxY(), this.model.getPixelsSizeX(), this.model.getPixelsSizeY(), this.model.getPixelsSizeZ());
        UIUtilities.centerAndShow(d);
    }

    public void addView(JComponent comp) {
        if (this.model.getState() != 6) {
            return;
        }
        if (comp == null) {
            return;
        }
        this.model.getBrowser().addComponent(comp, 0);
        comp.setVisible(true);
        this.view.repaint();
    }

    public void removeView(JComponent comp) {
        if (this.model.getState() != 6) {
            return;
        }
        if (comp == null) {
            return;
        }
        this.model.getBrowser().removeComponent(comp, 0);
        this.view.repaint();
    }

    public boolean hasLens() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getState() != 6) {
            return false;
        }
        return this.view.hasLensImage();
    }

    public double getZoomFactor() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getState() != 6) {
            return -1.0;
        }
        return this.model.getZoomFactor();
    }

    public boolean isMoviePlaying() {
        return this.model.isPlayingMovie();
    }

    public boolean isChannelRed(int index) {
        return this.model.isChannelRed(index);
    }

    public boolean isChannelGreen(int index) {
        return this.model.isChannelGreen(index);
    }

    public boolean isChannelBlue(int index) {
        return this.model.isChannelBlue(index);
    }

    public boolean isChannelActive(int index) {
        return this.model.isChannelActive(index);
    }
}

