/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelButton;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

class ControlPane
extends JPanel
implements ActionListener,
ChangeListener,
MouseWheelListener {
    private static final String Z_SLIDER_DESCRIPTION = "Use the slider to select a z-section.";
    private static final String T_SLIDER_DESCRIPTION = "Use the slider to select a timepoint.";
    private static final String Z_SLIDER_TIPSTRING = "Z";
    private static final String T_SLIDER_TIPSTRING = "T";
    private static final Dimension VBOX = new Dimension(1, 10);
    private ImViewerControl controller;
    private ImViewerModel model;
    private ImViewerUI view;
    private JComboBox ratingBox;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private OneKnobSlider zSliderGrid;
    private OneKnobSlider tSliderGrid;
    private OneKnobSlider zSliderAnnotator;
    private OneKnobSlider tSliderAnnotator;
    private HashSet<ChannelButton> channelButtons;
    private JButton channelMovieButton;
    private JButton colorModelButton;
    private JButton colorModelButtonGrid;
    private JButton colorPickerButton;
    private JToggleButton textVisibleButton;
    private JButton playMovie;
    private IconManager icons;

    private void mouseWheelMovedZ(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
            }
        }
    }

    private void mouseWheelMovedT(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxT()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
            }
        }
    }

    private String getColorModelDescription(String model) {
        if (model.equals("greyscale")) {
            return "Greyscale model.";
        }
        if (model.equals("rgb")) {
            return "Colour model.";
        }
        if (model.equals("hsb")) {
            return "Colour model.";
        }
        return null;
    }

    private Icon getColorModelIcon(String model) {
        if (model.equals("greyscale")) {
            return this.icons.getIcon(IconManager.GRAYSCALE);
        }
        if (model.equals("rgb")) {
            return this.icons.getIcon(IconManager.RGB);
        }
        if (model.equals("hsb")) {
            return this.icons.getIcon(IconManager.RGB);
        }
        return null;
    }

    private void initComponents() {
        ViewerAction[] ratingActions = new ViewerAction[]{this.controller.getAction(ImViewerControl.RATING_ONE), this.controller.getAction(ImViewerControl.RATING_TWO), this.controller.getAction(ImViewerControl.RATING_THREE), this.controller.getAction(ImViewerControl.RATING_FOUR), this.controller.getAction(ImViewerControl.RATING_FIVE)};
        this.ratingBox = new JComboBox<ViewerAction>(ratingActions);
        this.ratingBox.setEnabled(false);
        this.zSlider = new OneKnobSlider(1, 0, 1, 0);
        this.zSlider.setEnabled(false);
        this.tSlider = new OneKnobSlider(0, 0, 1, 0);
        this.tSlider.setEnabled(false);
        this.zSliderGrid = new OneKnobSlider(1, 0, 1, 0);
        this.zSliderGrid.setEnabled(false);
        this.tSliderGrid = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderGrid.setEnabled(false);
        this.zSliderAnnotator = new OneKnobSlider(1, 0, 1, 0);
        this.zSliderAnnotator.setEnabled(false);
        this.tSliderAnnotator = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderAnnotator.setEnabled(false);
        this.channelMovieButton = new JButton(this.controller.getAction(ImViewerControl.CHANNEL_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.channelMovieButton);
        this.colorModelButton = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButton);
        this.colorModelButton.addActionListener(this.controller);
        this.colorModelButtonGrid = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButtonGrid);
        this.colorModelButtonGrid.addActionListener(this.controller);
        ViewerAction a = this.controller.getAction(ImViewerControl.COLOR_PICKER);
        this.colorPickerButton = new JButton(a);
        this.colorPickerButton.addMouseListener((ColorPickerAction)a);
        UIUtilities.unifiedButtonLookAndFeel(this.colorPickerButton);
        this.textVisibleButton = new JToggleButton();
        this.textVisibleButton.setSelected(this.model.isTextVisible());
        this.textVisibleButton.setAction(this.controller.getAction(ImViewerControl.TEXT_VISIBLE));
        this.playMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.playMovie);
    }

    private void initSlider(OneKnobSlider slider, int max, int v, String toolTip, String endLabel) {
        slider.setVisible(max != 0);
        slider.setMaximum(max);
        slider.setValue(v);
        slider.addChangeListener(this);
        slider.addMouseWheelListener(this);
        slider.setToolTipText(toolTip);
        slider.setEndLabel(endLabel);
        slider.setShowEndLabel(true);
        slider.setShowTipLabel(true);
    }

    private void initializeValues() {
        switch (this.model.getRatingLevel()) {
            case 3: {
                this.ratingBox.setSelectedIndex(0);
                break;
            }
            case 4: {
                this.ratingBox.setSelectedIndex(1);
                break;
            }
            case 5: {
                this.ratingBox.setSelectedIndex(2);
                break;
            }
            case 6: {
                this.ratingBox.setSelectedIndex(3);
                break;
            }
            case 7: {
                this.ratingBox.setSelectedIndex(4);
            }
        }
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        this.ratingBox.addActionListener(this);
        this.initSlider(this.zSlider, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.zSliderGrid, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.zSliderAnnotator, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.tSlider, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.initSlider(this.tSliderGrid, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.initSlider(this.tSliderAnnotator, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.playMovie.setVisible(maxT != 0);
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
    }

    private JPanel createSliderPane(JSlider slider) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(slider);
        return pane;
    }

    private JPanel createSliderPanes() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.createSliderPane(this.zSlider));
        return p;
    }

    private JToolBar buildToolBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.colorModelButton);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.channelMovieButton);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.colorPickerButton);
        return bar;
    }

    private JToolBar buildGridBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.colorModelButtonGrid);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.textVisibleButton);
        return bar;
    }

    private JPanel createChannelsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        ChannelMetadata[] data = this.model.getChannelData();
        p.add(Box.createRigidArea(VBOX));
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (int k = 0; k < data.length; ++k) {
            ChannelMetadata d = data[k];
            ChannelButton button = new ChannelButton("" + d.getEmissionWavelength(), this.model.getChannelColor(k), k, this.model.isChannelActive(k));
            if (gs) {
                button.setGrayedOut(gs);
            }
            button.addPropertyChangeListener(this.controller);
            button.setPreferredSize(ChannelButton.DEFAULT_MIN_SIZE);
            this.channelButtons.add(button);
            p.add(button);
            p.add(Box.createRigidArea(VBOX));
        }
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(Box.createVerticalStrut(20));
        controls.add(this.buildToolBar());
        controls.add(p);
        return UIUtilities.buildComponentPanel(controls);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.createChannelsPane());
        this.add(this.createSliderPanes());
    }

    private void updateSlider(JSlider slider, int v) {
        slider.removeChangeListener(this);
        slider.setValue(v);
        slider.addChangeListener(this);
    }

    ControlPane(ImViewerControl controller, ImViewerModel model, ImViewerUI view) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.channelButtons = new HashSet();
        this.icons = IconManager.getInstance();
        this.initComponents();
    }

    void buildComponent() {
        this.initializeValues();
        this.buildGUI();
    }

    JPanel buildAnnotatorComponent() {
        return this.createSliderPane(this.zSliderAnnotator);
    }

    JPanel buildGridComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.createSliderPane(this.zSliderGrid));
        p.add(this.createSliderPane(this.tSliderGrid));
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        ChannelMetadata[] data = this.model.getChannelData();
        buttons.add(Box.createRigidArea(VBOX));
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (int k = 0; k < data.length; ++k) {
            ChannelMetadata d = data[k];
            ChannelButton button = new ChannelButton("" + d.getEmissionWavelength(), this.model.getChannelColor(k), k, this.model.isChannelActive(k));
            if (gs) {
                button.setGrayedOut(gs);
            }
            button.addPropertyChangeListener(this.controller);
            button.setPreferredSize(ChannelButton.DEFAULT_MIN_SIZE);
            this.channelButtons.add(button);
            buttons.add(button);
            buttons.add(Box.createRigidArea(VBOX));
        }
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(Box.createVerticalStrut(20));
        controls.add(this.buildGridBar());
        controls.add(buttons);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(UIUtilities.buildComponentPanel(controls));
        content.add(p);
        return content;
    }

    void setTimepoint(int t) {
        this.updateSlider(this.tSlider, t);
        this.updateSlider(this.tSliderGrid, t);
        this.updateSlider(this.tSliderAnnotator, t);
    }

    void setZSection(int z) {
        this.updateSlider(this.zSlider, z);
        this.updateSlider(this.zSliderGrid, z);
        this.updateSlider(this.zSliderAnnotator, z);
    }

    void setRatingFactor(ViewerAction action) {
        this.ratingBox.removeActionListener(this);
        this.ratingBox.setSelectedItem(action);
        this.ratingBox.addActionListener(this);
    }

    void setColorModel() {
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (ChannelButton button : this.channelButtons) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
            button.setGrayedOut(gs);
        }
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
    }

    void setChannelsSelection() {
        for (ChannelButton button : this.channelButtons) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
        }
    }

    void setChannelColor(int index, Color c) {
        for (ChannelButton button : this.channelButtons) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
        }
    }

    void resetDefaults() {
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (ChannelButton button : this.channelButtons) {
            int index = button.getChannelIndex();
            button.setSelected(this.model.isChannelActive(index));
            button.setColor(this.model.getChannelColor(index));
            button.setGrayedOut(gs);
        }
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.setZSection(this.model.getDefaultZ());
        this.setTimepoint(this.model.getDefaultT());
    }

    JPanel createGridSliderPanes() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.createSliderPane(this.zSliderGrid));
        return p;
    }

    void onStateChange(boolean b) {
        if (this.model.isPlayingMovie()) {
            this.enableSliders(!b);
        } else {
            this.enableSliders(b);
        }
        this.ratingBox.setEnabled(b);
        Iterator<ChannelButton> i = this.channelButtons.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        this.colorModelButton.setEnabled(b);
    }

    JPanel getTimeSliderPane(int index) {
        switch (index) {
            case 1: {
                return this.createSliderPane(this.tSliderAnnotator);
            }
            case 2: {
                return this.createSliderPane(this.tSliderGrid);
            }
        }
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.playMovie);
        pane.add(this.tSlider);
        return pane;
    }

    void enableSliders(boolean b) {
        if (b) {
            this.zSlider.setEnabled(this.model.getMaxZ() != 0);
            this.tSlider.setEnabled(this.model.getMaxT() != 0);
            this.zSliderGrid.setEnabled(this.model.getMaxZ() != 0);
            this.tSliderGrid.setEnabled(this.model.getMaxT() != 0);
            this.zSliderAnnotator.setEnabled(this.model.getMaxZ() != 0);
            this.tSliderAnnotator.setEnabled(this.model.getMaxT() != 0);
        } else {
            this.zSlider.setEnabled(b);
            this.tSlider.setEnabled(b);
            this.zSliderGrid.setEnabled(b);
            this.tSliderGrid.setEnabled(b);
            this.zSliderAnnotator.setEnabled(b);
            this.tSliderAnnotator.setEnabled(b);
        }
    }

    void setChannelActive(int index) {
        for (ChannelButton button : this.channelButtons) {
            if (index != button.getChannelIndex()) continue;
            button.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        ViewerAction va = (ViewerAction)cb.getSelectedItem();
        va.actionPerformed(e);
    }

    public void stateChanged(ChangeEvent e) {
        Object object = e.getSource();
        if (object instanceof JSlider) {
            if (object == this.zSlider || object == this.tSlider) {
                this.controller.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue());
            } else if (object == this.zSliderGrid || object == this.tSliderGrid) {
                this.controller.setSelectedXYPlane(this.zSliderGrid.getValue(), this.tSliderGrid.getValue());
            } else if (object == this.zSliderAnnotator || object == this.tSliderAnnotator) {
                this.controller.setSelectedXYPlane(this.zSliderAnnotator.getValue(), this.tSliderAnnotator.getValue());
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source == this.zSlider && this.zSlider.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSlider && this.tSlider.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.zSliderGrid && this.zSliderGrid.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSliderGrid && this.tSliderGrid.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.zSliderAnnotator && this.zSliderAnnotator.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSliderAnnotator && this.tSliderAnnotator.isEnabled()) {
            this.mouseWheelMovedT(e);
        }
    }
}

