/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaver;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverFileChooser;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImgSaverUI {
    static final String SAVE_AS = "Save the current image inthe specified format.";
    static final int IMAGE = 0;
    static final int GRID_IMAGE = 1;
    static final int IMAGE_AND_COMPONENTS = 2;
    static final int IMAGE_AND_COMPONENTS_GREY = 3;
    static final int LENS_IMAGE = 4;
    static final int LENS_IMAGE_AND_COMPONENTS = 5;
    static final int LENS_IMAGE_AND_COMPONENTS_GREY = 6;
    private static final int MAX = 6;
    private static final int MAX_PARTIAL = 3;
    private static final String NOTE = "Save the currrent image in one of the following formats: TIFF, JPEG, PNG or BMP.";
    private static final String PREVIEW = "Preview the image to save.";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final String[] selections = new String[7];
    private static final String[] partialSelections;
    private ImgSaver model;
    private JComboBox savingTypes;
    private ImgSaverFileChooser chooser;
    private JCheckBox settings;
    private JButton cancelButton;
    private JButton saveButton;
    private JButton previewButton;

    private void initComponents() {
        switch (this.model.getSavingType()) {
            case 1: {
                this.savingTypes = new JComboBox<String>(partialSelections);
                break;
            }
            default: {
                this.savingTypes = new JComboBox<String>(selections);
            }
        }
        this.chooser = new ImgSaverFileChooser(this.model, this);
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgSaverUI.this.chooser.cancelSelection();
            }
        });
        this.saveButton = new JButton("Save as");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_AS));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgSaverUI.this.chooser.approveSelection();
            }
        });
        this.saveButton.setEnabled(false);
        this.previewButton = new JButton("Preview");
        this.previewButton.setToolTipText(UIUtilities.formatToolTipText(PREVIEW));
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImgSaverUI.this.chooser.previewSelection();
            }
        });
        this.previewButton.setEnabled(false);
        this.model.getRootPane().setDefaultButton(this.saveButton);
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.previewButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private JPanel buildSelectionPane() {
        JPanel p = new JPanel();
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        JLabel l = new JLabel("Images: ");
        result.add(l);
        result.add(UIUtilities.buildComponentPanel(this.savingTypes));
        p.setLayout(new BoxLayout(p, 0));
        p.add(result);
        p.add(UIUtilities.buildComponentPanelRight(this.settings));
        return p;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout(0, 0));
        controls.add((Component)this.buildToolbar(), "Center");
        controls.add((Component)this.buildSelectionPane(), "South");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)controls, "South");
        IconManager im = IconManager.getInstance();
        Container c = this.model.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        TitlePanel tp = new TitlePanel("Save Image", NOTE, im.getIcon(IconManager.SAVE_BIG));
        c.add((Component)tp, "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.model.getRootPane().setWindowDecorationStyle(6);
        }
    }

    ImgSaverUI(ImgSaver model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    int getSavingType() {
        return this.savingTypes.getSelectedIndex();
    }

    String getCurrentDirectory() {
        return this.chooser.getCurrentDirectory().toString();
    }

    boolean isSetDefaultFolder() {
        return this.settings.isSelected();
    }

    void setControlsEnabled(boolean b) {
        this.saveButton.setEnabled(b);
        this.previewButton.setEnabled(b);
    }

    static {
        ImgSaverUI.selections[0] = "image";
        ImgSaverUI.selections[1] = "grid view";
        ImgSaverUI.selections[2] = "image and split channels";
        ImgSaverUI.selections[3] = "image and split channels in grey";
        ImgSaverUI.selections[4] = "lens' image";
        ImgSaverUI.selections[5] = "lens' image and split channels";
        ImgSaverUI.selections[6] = "lens' image and split channels  in grey";
        partialSelections = new String[4];
        ImgSaverUI.partialSelections[0] = "image";
        ImgSaverUI.partialSelections[1] = "grid view";
        ImgSaverUI.partialSelections[2] = "image and split channels";
        ImgSaverUI.partialSelections[3] = "image and split channels in grey";
    }
}

