/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverPreviewer;

class ImgSaverPreviewerCanvas
extends JPanel {
    private ImgSaverPreviewer model;

    private int paintComponents(Graphics2D g2D, int w, boolean b, String v, int size) {
        for (BufferedImage img : this.model.getImageComponents()) {
            g2D.drawImage(img, null, w, 10);
            int width = img.getWidth();
            if (b && v != null && size < width && this.model.getType() != 5) {
                ImagePaintingFactory.paintScaleBar(g2D, w + width - size - 10, 10 + img.getHeight() - 10, size, v, this.model.getUnitBarColor());
            }
            w += width + 10;
        }
        return w;
    }

    ImgSaverPreviewerCanvas(ImgSaverPreviewer model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.setFont(this.getFont().deriveFont(10.0f));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        BufferedImage img = this.model.getImage();
        if (img == null) {
            return;
        }
        boolean unitBar = this.model.isUnitBar();
        String value = this.model.getUnitBarValue();
        int size = (int)this.model.getUnitBarSize();
        int w = 10;
        if (this.model.getImageComponents() != null) {
            w = this.paintComponents(g2D, w, unitBar, value, size);
        }
        g2D.drawImage(img, null, w, 10);
        int width = img.getWidth();
        if (unitBar && value != null && size < width && this.model.getType() == 0) {
            ImagePaintingFactory.paintScaleBar(g2D, w + width - size - 10, 10 + img.getHeight() - 10, size, value, this.model.getUnitBarColor());
        }
    }
}

