/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

class MoviePlayerControl
implements ActionListener,
ChangeListener,
FocusListener,
PropertyChangeListener {
    private static final int START_T = 0;
    private static final int END_T = 1;
    private static final int START_Z = 2;
    private static final int END_Z = 3;
    private static final int PLAY_CMD = 4;
    private static final int PAUSE_CMD = 5;
    private static final int STOP_CMD = 6;
    private static final int MOVIE_TYPE_CMD = 7;
    private static final int EDITOR_CMD = 8;
    private static final int ACROSS_Z_CMD = 9;
    private static final int ACROSS_T_CMD = 10;
    private static final int ACROSS_ZT_CMD = 11;
    private static final int TYPE_Z = 200;
    private static final int TYPE_T = 201;
    private MoviePlayer model;
    private MoviePlayerUI view;

    private void attachButtonListener(AbstractButton button, int id) {
        button.addActionListener(this);
        button.setActionCommand("" + id);
    }

    private void attachFieldListeners(JTextField field, int id) {
        field.setActionCommand("" + id);
        field.addActionListener(this);
        field.addFocusListener(this);
    }

    private void initListeners() {
        JTextField editor = this.view.editor;
        editor.addActionListener(this);
        editor.setActionCommand("8");
        this.attachButtonListener(this.view.play, 4);
        this.attachButtonListener(this.view.pause, 5);
        this.attachButtonListener(this.view.stop, 6);
        JComboBox box = this.view.movieTypes;
        box.setActionCommand("7");
        box.addActionListener(this);
        this.view.fps.addChangeListener(this);
        this.attachFieldListeners(this.view.startT, 0);
        this.attachFieldListeners(this.view.endT, 1);
        this.attachFieldListeners(this.view.startZ, 2);
        this.attachFieldListeners(this.view.endZ, 3);
        this.attachButtonListener(this.view.acrossZ, 9);
        this.attachButtonListener(this.view.acrossT, 10);
        this.attachButtonListener(this.view.acrossZT, 11);
        this.view.tSlider.addPropertyChangeListener(this);
        this.view.zSlider.addPropertyChangeListener(this);
    }

    private void movieStartActionHandler(JTextField start, JTextField end, int type) {
        boolean valid = false;
        int val = 0;
        int valEnd = 0;
        if (type == 201) {
            valEnd = this.model.getMaxT();
        } else if (type == 200) {
            valEnd = this.model.getMaxZ();
        }
        try {
            val = Integer.parseInt(start.getText());
            valEnd = Integer.parseInt(end.getText());
            if (type == 200) {
                --val;
                --valEnd;
            }
            if (0 <= val && val < valEnd) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (!valid) {
            int v = valEnd + 1;
            start.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid start point", "Please enter a value between 1 and " + v);
            return;
        }
        if (type == 201) {
            this.model.setStartT(val);
            this.view.setStartT(val);
        } else if (type == 200) {
            this.model.setStartZ(val);
            this.view.setStartZ(val);
        }
    }

    private void movieEndActionHandler(JTextField start, JTextField end, int type) {
        boolean valid = false;
        int val = 0;
        int valStart = 0;
        int max = 0;
        if (type == 201) {
            max = this.model.getMaxT();
        } else if (type == 200) {
            max = this.model.getMaxZ();
        }
        try {
            val = Integer.parseInt(end.getText());
            valStart = Integer.parseInt(start.getText());
            if (type == 200) {
                --val;
                --valStart;
            }
            if (valStart < val && val <= max) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (!valid) {
            end.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            int v = valStart + 1;
            un.notifyInfo("Invalid end point", "Please enter a value between " + v + " and " + (max + 1));
            return;
        }
        if (type == 201) {
            this.model.setEndT(val);
            this.view.setEndT(val);
        } else if (type == 200) {
            this.model.setEndZ(val);
            this.view.setEndZ(val);
        }
    }

    private void editorActionHandler() {
        boolean valid = false;
        int val = 1;
        int maxValue = 0;
        try {
            val = Integer.parseInt(this.view.editor.getText());
            if (1 <= val && val <= maxValue) {
                valid = true;
            } else if (val < 1) {
                val = 1;
                valid = true;
            } else if (val > maxValue) {
                val = maxValue;
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (valid) {
            this.model.setTimerDelay(val);
            this.view.setTimerDelay(val);
        } else {
            this.view.editor.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid value", "Please enter a value between 1 and " + maxValue);
        }
    }

    MoviePlayerControl(MoviePlayer model, MoviePlayerUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.model = model;
        this.initListeners();
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            int index = Integer.parseInt(ae.getActionCommand());
            switch (index) {
                case 0: {
                    this.movieStartActionHandler(this.view.startT, this.view.endT, 201);
                    break;
                }
                case 1: {
                    this.movieEndActionHandler(this.view.startT, this.view.endT, 201);
                    break;
                }
                case 2: {
                    this.movieStartActionHandler(this.view.startZ, this.view.endZ, 200);
                    break;
                }
                case 3: {
                    this.movieEndActionHandler(this.view.startZ, this.view.endZ, 200);
                    break;
                }
                case 10: {
                    this.model.setMovieIndex(301);
                    break;
                }
                case 9: {
                    this.model.setMovieIndex(300);
                    break;
                }
                case 11: {
                    this.model.setMovieIndex(302);
                    break;
                }
                case 4: {
                    this.model.setPlayerState(0);
                    break;
                }
                case 5: {
                    this.model.setPlayerState(2);
                    break;
                }
                case 6: {
                    this.model.setPlayerState(1);
                    break;
                }
                case 8: {
                    this.editorActionHandler();
                    break;
                }
                case 7: {
                    int i = ((JComboBox)ae.getSource()).getSelectedIndex();
                    this.model.setMovieType(this.view.getMovieType(i));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + ae.getActionCommand(), nfe);
        }
    }

    public void stateChanged(ChangeEvent e) {
        int v = (Integer)this.view.fps.getValue();
        this.model.setTimerDelay(v);
        this.view.setTimerDelay(v);
    }

    public void focusLost(FocusEvent e) {
        String edit = this.view.editor.getText();
        String ed = "" + this.model.getTimerDelay();
        if (edit == null || !edit.equals(ed)) {
            this.view.editor.setText(ed);
        }
        String startT = "" + this.model.getStartT();
        String endT = "" + this.model.getEndT();
        String startVal = this.view.startT.getText();
        String endVal = this.view.endT.getText();
        if (startVal == null || !startVal.equals(startT)) {
            this.view.startT.setText(startT);
        }
        if (endVal == null || !endVal.equals(endT)) {
            this.view.endT.setText(endT);
        }
        String startZ = "" + (this.model.getStartZ() + 1);
        String endZ = "" + (this.model.getEndZ() + 1);
        startVal = this.view.startZ.getText();
        endVal = this.view.endZ.getText();
        if (startVal == null || !startVal.equals(startZ)) {
            this.view.startZ.setText(startZ);
        }
        if (endVal == null || !endVal.equals(endZ)) {
            this.view.endZ.setText(endZ);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        int s = -1;
        int e = -1;
        if (name.equals("leftMoved")) {
            if (source.equals(this.view.zSlider)) {
                s = this.view.zSlider.getStartValue();
                this.model.setStartZ(s);
                this.view.setStartZ(s);
            } else if (source.equals(this.view.tSlider)) {
                s = this.view.tSlider.getStartValue();
                this.model.setStartT(s);
                this.view.setStartT(s);
            }
        }
        if (name.equals("rightMoved")) {
            if (source.equals(this.view.zSlider)) {
                e = this.view.zSlider.getEndValue();
                this.model.setEndZ(e);
                this.view.setEndZ(e);
            } else if (source.equals(this.view.tSlider)) {
                e = this.view.tSlider.getEndValue();
                this.model.setEndT(e);
                this.view.setEndT(e);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

