/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.cdm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingPane;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingPaneStatic;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PlaneSlicingUI
extends JPanel {
    private static final String TEXT_STATIC = "<html>Highlights a range,<br>preserves others (cf. (2)).</html>";
    private static final String TEXT_NOT_STATIC = "<html>Highlights a range,<br>reduces others to a constant level(cf. (1)).</html>";
    private static final Dimension VBOX = new Dimension(0, 10);
    private static final Dimension DIM = new Dimension(220, 200);
    private static final Dimension DIM_ALL = new Dimension(440, 200);
    private static final String[] BIT_PLANES = new String[7];
    private PlaneSlicingPane pane;
    private PlaneSlicingPaneStatic paneStatic;
    private PlaneSlicingDialog model;

    private int convertRealIntoGraphics(int x, int r, int b) {
        double a = 140.0 / (double)r;
        return (int)(a * (double)(x - b));
    }

    private void initComponents() {
        this.pane = new PlaneSlicingPane(this.model);
        this.paneStatic = new PlaneSlicingPaneStatic(this.model);
        int yStart = 20 + this.convertRealIntoGraphics(this.model.getLowerLimit(), this.model.cdStart - this.model.cdEnd, this.model.cdEnd);
        int yEnd = 20 + this.convertRealIntoGraphics(this.model.getUpperLimit(), this.model.cdStart - this.model.cdEnd, this.model.cdEnd);
        this.pane.initialize(yStart, yEnd);
    }

    private JPanel buildControlsPane() {
        JPanel controls = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        controls.setLayout(new GridBagLayout());
        c.anchor = 13;
        c.fill = 2;
        ButtonGroup group = new ButtonGroup();
        JRadioButton button = new JRadioButton(TEXT_STATIC);
        button.setSelected(this.model.isContextConstant());
        group.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlaneSlicingUI.this.model.setPaneIndex(0);
            }
        });
        controls.add((Component)button, c);
        button = new JRadioButton(TEXT_NOT_STATIC);
        button.setSelected(this.model.isContextConstant());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlaneSlicingUI.this.model.setPaneIndex(0);
            }
        });
        group.add(button);
        c.gridy = 1;
        controls.add((Component)button, c);
        JComboBox<String> bitPlanes = new JComboBox<String>(BIT_PLANES);
        bitPlanes.setSelectedIndex(this.model.getBitPlaneIndex());
        bitPlanes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                PlaneSlicingUI.this.model.setBitPlaneIndex(box.getSelectedIndex());
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        JLabel label = new JLabel(" Select a plane: ");
        p.add(label);
        p.add(UIUtilities.buildComponentPanel(bitPlanes));
        c.gridy = 2;
        controls.add((Component)p, c);
        return UIUtilities.buildComponentPanel(controls);
    }

    private JPanel buildGraphicsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setPreferredSize(DIM_ALL);
        p.setSize(DIM_ALL);
        this.pane.setPreferredSize(DIM);
        this.pane.setSize(DIM);
        p.add(this.pane);
        this.paneStatic.setPreferredSize(DIM);
        this.paneStatic.setSize(DIM);
        p.add(this.paneStatic);
        return p;
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildGraphicsPane());
        this.add(Box.createRigidArea(VBOX));
        this.add(this.buildControlsPane());
    }

    PlaneSlicingUI(PlaneSlicingDialog model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    static {
        PlaneSlicingUI.BIT_PLANES[0] = "1-bit plane";
        PlaneSlicingUI.BIT_PLANES[1] = "2-bit plane";
        PlaneSlicingUI.BIT_PLANES[2] = "3-bit plane";
        PlaneSlicingUI.BIT_PLANES[3] = "4-bit plane";
        PlaneSlicingUI.BIT_PLANES[4] = "5-bit plane";
        PlaneSlicingUI.BIT_PLANES[5] = "6-bit plane";
        PlaneSlicingUI.BIT_PLANES[6] = "7-bit plane";
    }
}

